rule win_roll_sling_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.roll_sling."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.roll_sling"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ba04000000 488bcf e8???????? 498bce 48833d????????10 480f430d???????? }
            // n = 6, score = 100
            //   ba04000000           | dec                 eax
            //   488bcf               | lea                 eax, [ebp - 0x40]
            //   e8????????           |                     
            //   498bce               | dec                 ecx
            //   48833d????????10     |                     
            //   480f430d????????     |                     

        $sequence_1 = { 492bd0 4803d7 e8???????? 4533c9 4533c0 }
            // n = 5, score = 100
            //   492bd0               | cmove               edx, ebx
            //   4803d7               | dec                 eax
            //   e8????????           |                     
            //   4533c9               | lea                 ecx, [0x1bb9a]
            //   4533c0               | dec                 eax

        $sequence_2 = { 42385cf839 0f84ca000000 488d05a9ee0000 4a8b0ce8 488d55f0 4a8b4cf928 }
            // n = 6, score = 100
            //   42385cf839           | dec                 eax
            //   0f84ca000000         | sub                 eax, ecx
            //   488d05a9ee0000       | cmp                 eax, 0xe4
            //   4a8b0ce8             | jae                 0xf0
            //   488d55f0             | dec                 eax
            //   4a8b4cf928           | cwde                

        $sequence_3 = { 4c8d0d63b40000 8bda 4c8d0552b40000 488bf9 488d1550b40000 b904000000 e8???????? }
            // n = 7, score = 100
            //   4c8d0d63b40000       | mov                 edi, eax
            //   8bda                 | dec                 eax
            //   4c8d0552b40000       | lea                 edx, [0x1abfd]
            //   488bf9               | dec                 eax
            //   488d1550b40000       | lea                 ecx, [ebp - 0x80]
            //   b904000000           | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 440f44d2 0fb74806 41ffc4 4c8b442468 4883c328 443be1 }
            // n = 6, score = 100
            //   440f44d2             | dec                 esp
            //   0fb74806             | sub                 ecx, eax
            //   41ffc4               | inc                 ecx
            //   4c8b442468           | movzx               ecx, byte ptr [ecx]
            //   4883c328             | inc                 ecx
            //   443be1               | inc                 eax

        $sequence_5 = { 4883c227 4d8b6df8 492bc5 4883c0f8 4883f81f 0f877c040000 498bcd }
            // n = 7, score = 100
            //   4883c227             | lea                 ebx, [eax + 0x64]
            //   4d8b6df8             | dec                 eax
            //   492bc5               | add                 ebx, edx
            //   4883c0f8             | inc                 esp
            //   4883f81f             | mov                 esi, dword ptr [ebx - 0x1c]
            //   0f877c040000         | mov                 esi, dword ptr [ebx - 0x14]
            //   498bcd               | dec                 ebp

        $sequence_6 = { 483bc3 7306 4c8bf3 488bd8 4533c9 4c8bc3 }
            // n = 6, score = 100
            //   483bc3               | dec                 eax
            //   7306                 | sub                 edx, eax
            //   4c8bf3               | mov                 eax, dword ptr [edx - 4]
            //   488bd8               | shr                 eax, cl
            //   4533c9               | dec                 ecx
            //   4c8bc3               | mov                 dword ptr [ecx + 8], edx

        $sequence_7 = { 448bb090000000 4d03f7 498bce ff15???????? 85c0 0f8530010000 }
            // n = 6, score = 100
            //   448bb090000000       | mov                 ecx, ebx
            //   4d03f7               | test                eax, eax
            //   498bce               | jne                 0x63
            //   ff15????????         |                     
            //   85c0                 | inc                 ecx
            //   0f8530010000         | and                 edx, 0x4000000

        $sequence_8 = { eb14 4889742420 4c8d4da0 488bd6 }
            // n = 4, score = 100
            //   eb14                 | dec                 esp
            //   4889742420           | mov                 edi, dword ptr [ebp - 0x80]
            //   4c8d4da0             | dec                 esp
            //   488bd6               | lea                 eax, [0xffff8a45]

        $sequence_9 = { 4c89742428 4c897c2420 e8???????? 488bcb 488bf0 e8???????? }
            // n = 6, score = 100
            //   4c89742428           | inc                 eax
            //   4c897c2420           | inc                 edx
            //   e8????????           |                     
            //   488bcb               | cmp                 byte ptr [eax + eax], 0
            //   488bf0               | jne                 0x10ea
            //   e8????????           |                     

    condition:
        7 of them and filesize < 299008
}