rule win_rombertik_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rombertik."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rombertik"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 56 ff15???????? 85c0 7559 8b5e10 33ff }
            // n = 7, score = 200
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7559                 | jne                 0x5b
            //   8b5e10               | mov                 ebx, dword ptr [esi + 0x10]
            //   33ff                 | xor                 edi, edi

        $sequence_1 = { 40 49 75f9 8955f8 85d2 }
            // n = 5, score = 200
            //   40                   | inc                 eax
            //   49                   | dec                 ecx
            //   75f9                 | jne                 0xfffffffb
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   85d2                 | test                edx, edx

        $sequence_2 = { 0f94c0 84c0 750d 47 3b7d0c 72c9 }
            // n = 6, score = 200
            //   0f94c0               | sete                al
            //   84c0                 | test                al, al
            //   750d                 | jne                 0xf
            //   47                   | inc                 edi
            //   3b7d0c               | cmp                 edi, dword ptr [ebp + 0xc]
            //   72c9                 | jb                  0xffffffcb

        $sequence_3 = { 47 41 3bfb 72be 8b5df0 }
            // n = 5, score = 200
            //   47                   | inc                 edi
            //   41                   | inc                 ecx
            //   3bfb                 | cmp                 edi, ebx
            //   72be                 | jb                  0xffffffc0
            //   8b5df0               | mov                 ebx, dword ptr [ebp - 0x10]

        $sequence_4 = { 85c0 7426 8d95f8feffff 52 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   7426                 | je                  0x28
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]
            //   52                   | push                edx

        $sequence_5 = { 8d4de4 51 8955e8 8b55fc 6a00 52 }
            // n = 6, score = 200
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   51                   | push                ecx
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   6a00                 | push                0
            //   52                   | push                edx

        $sequence_6 = { 8bec 81ec3c030000 53 56 57 bf00010000 }
            // n = 6, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec3c030000         | sub                 esp, 0x33c
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   bf00010000           | mov                 edi, 0x100

        $sequence_7 = { 8d8ddcfdffff 8bf0 51 56 }
            // n = 4, score = 200
            //   8d8ddcfdffff         | lea                 ecx, [ebp - 0x224]
            //   8bf0                 | mov                 esi, eax
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_8 = { 68???????? 50 56 e8???????? 83c414 a3???????? }
            // n = 6, score = 200
            //   68????????           |                     
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   a3????????           |                     

        $sequence_9 = { 81c900ffffff 41 8a9c0d00ffffff 889c0500ffffff }
            // n = 4, score = 200
            //   81c900ffffff         | or                  ecx, 0xffffff00
            //   41                   | inc                 ecx
            //   8a9c0d00ffffff       | mov                 bl, byte ptr [ebp + ecx - 0x100]
            //   889c0500ffffff       | mov                 byte ptr [ebp + eax - 0x100], bl

    condition:
        7 of them and filesize < 73728
}