rule win_rovnix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rovnix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rovnix"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c335 c1e902 ad 2bc3 }
            // n = 4, score = 900
            //   83c335               | add                 ebx, 0x35
            //   c1e902               | shr                 ecx, 2
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   2bc3                 | sub                 eax, ebx

        $sequence_1 = { 57 6a00 ffd2 89442408 8bcf }
            // n = 5, score = 900
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ffd2                 | call                edx
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8bcf                 | mov                 ecx, edi

        $sequence_2 = { ad 2bc3 ab e2fa 61 }
            // n = 5, score = 900
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   2bc3                 | sub                 eax, ebx
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   e2fa                 | loop                0xfffffffc
            //   61                   | popal               

        $sequence_3 = { 837c242c00 7405 57 6a00 }
            // n = 4, score = 900
            //   837c242c00           | cmp                 dword ptr [esp + 0x2c], 0
            //   7405                 | je                  7
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_4 = { 8b15???????? 83e7f0 89542418 83c710 8bea }
            // n = 5, score = 900
            //   8b15????????         |                     
            //   83e7f0               | and                 edi, 0xfffffff0
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   83c710               | add                 edi, 0x10
            //   8bea                 | mov                 ebp, edx

        $sequence_5 = { 60 bf40090000 be???????? 8b15???????? }
            // n = 4, score = 500
            //   60                   | pushal              
            //   bf40090000           | mov                 edi, 0x940
            //   be????????           |                     
            //   8b15????????         |                     

        $sequence_6 = { 8b4d0c 897604 8936 8d7e08 }
            // n = 4, score = 400
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   897604               | mov                 dword ptr [esi + 4], esi
            //   8936                 | mov                 dword ptr [esi], esi
            //   8d7e08               | lea                 edi, [esi + 8]

        $sequence_7 = { 8b7e10 eb06 8b5d0c 8b7d08 8bcf }
            // n = 5, score = 400
            //   8b7e10               | mov                 edi, dword ptr [esi + 0x10]
            //   eb06                 | jmp                 8
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8bcf                 | mov                 ecx, edi

        $sequence_8 = { 8bc2 c1e802 25ff000000 8d4cc324 8b01 }
            // n = 5, score = 400
            //   8bc2                 | mov                 eax, edx
            //   c1e802               | shr                 eax, 2
            //   25ff000000           | and                 eax, 0xff
            //   8d4cc324             | lea                 ecx, [ebx + eax*8 + 0x24]
            //   8b01                 | mov                 eax, dword ptr [ecx]

        $sequence_9 = { 85c0 e8???????? 8be5 5d }
            // n = 4, score = 400
            //   85c0                 | test                eax, eax
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_10 = { 25ff000000 8d4cc624 8b01 3bc1 }
            // n = 4, score = 400
            //   25ff000000           | and                 eax, 0xff
            //   8d4cc624             | lea                 ecx, [esi + eax*8 + 0x24]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   3bc1                 | cmp                 eax, ecx

        $sequence_11 = { 3bc1 75f3 395e14 7511 ff4e18 }
            // n = 5, score = 400
            //   3bc1                 | cmp                 eax, ecx
            //   75f3                 | jne                 0xfffffff5
            //   395e14               | cmp                 dword ptr [esi + 0x14], ebx
            //   7511                 | jne                 0x13
            //   ff4e18               | dec                 dword ptr [esi + 0x18]

        $sequence_12 = { 894804 8b4608 8b4e0c 8901 894804 8b4718 }
            // n = 6, score = 400
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]

        $sequence_13 = { 894f04 8939 897804 ff4308 }
            // n = 4, score = 400
            //   894f04               | mov                 dword ptr [edi + 4], ecx
            //   8939                 | mov                 dword ptr [ecx], edi
            //   897804               | mov                 dword ptr [eax + 4], edi
            //   ff4308               | inc                 dword ptr [ebx + 8]

        $sequence_14 = { 8975e4 c745ec40020000 8975e8 8975f0 }
            // n = 4, score = 400
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   c745ec40020000       | mov                 dword ptr [ebp - 0x14], 0x240
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi

        $sequence_15 = { 83f919 7703 83c220 85c0 7404 }
            // n = 5, score = 400
            //   83f919               | cmp                 ecx, 0x19
            //   7703                 | ja                  5
            //   83c220               | add                 edx, 0x20
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6

        $sequence_16 = { e8???????? 8be5 5d c3 85c0 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   85c0                 | test                eax, eax
            //   e8????????           |                     

        $sequence_17 = { 5d c3 85c9 e8???????? }
            // n = 4, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   85c9                 | test                ecx, ecx
            //   e8????????           |                     

        $sequence_18 = { 55 8bec 85db 85c9 }
            // n = 4, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   85db                 | test                ebx, ebx
            //   85c9                 | test                ecx, ecx

        $sequence_19 = { 23c9 16 85c9 23d2 }
            // n = 4, score = 200
            //   23c9                 | and                 ecx, ecx
            //   16                   | push                ss
            //   85c9                 | test                ecx, ecx
            //   23d2                 | and                 edx, edx

        $sequence_20 = { 23db 81e1ff000000 23c9 83440c0404 }
            // n = 4, score = 200
            //   23db                 | and                 ebx, ebx
            //   81e1ff000000         | and                 ecx, 0xff
            //   23c9                 | and                 ecx, ecx
            //   83440c0404           | add                 dword ptr [esp + ecx + 4], 4

        $sequence_21 = { 89442408 8bcf bb1092c63b 8bf8 83c335 c1e902 }
            // n = 6, score = 100
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8bcf                 | mov                 ecx, edi
            //   bb1092c63b           | mov                 ebx, 0x3bc69210
            //   8bf8                 | mov                 edi, eax
            //   83c335               | add                 ebx, 0x35
            //   c1e902               | shr                 ecx, 2

        $sequence_22 = { 57 4883ec20 488b35???????? 33c9 bb9a0000c0 e8???????? 33ed }
            // n = 7, score = 100
            //   57                   | dec                 eax
            //   4883ec20             | mov                 ecx, dword ptr [edx]
            //   488b35????????       |                     
            //   33c9                 | dec                 eax
            //   bb9a0000c0           | mov                 ecx, edi
            //   e8????????           |                     
            //   33ed                 | dec                 esp

        $sequence_23 = { aa 27 ff44a8d2 4b }
            // n = 4, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   27                   | daa                 
            //   ff44a8d2             | inc                 dword ptr [eax + ebp*4 - 0x2e]
            //   4b                   | dec                 ebx

        $sequence_24 = { e8???????? 483bf3 75ea 4883c310 4983ec01 75db 8a5508 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   483bf3               | mov                 esi, dword ptr [ebx + 0x48]
            //   75ea                 | push                edi
            //   4883c310             | dec                 eax
            //   4983ec01             | sub                 esp, 0x20
            //   75db                 | xor                 ecx, ecx
            //   8a5508               | mov                 ebx, 0xc000009a

        $sequence_25 = { 85c9 23c0 8be5 5d c20800 159e9dc35a fa }
            // n = 7, score = 100
            //   85c9                 | test                ecx, ecx
            //   23c0                 | and                 eax, eax
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   159e9dc35a           | adc                 eax, 0x5ac39d9e
            //   fa                   | cli                 

        $sequence_26 = { 488d8c2400010000 ba00001080 895c2428 897c2420 ff15???????? 85c0 7914 }
            // n = 7, score = 100
            //   488d8c2400010000     | dec                 eax
            //   ba00001080           | lea                 ecx, [esp + 0x100]
            //   895c2428             | mov                 edx, 0x80100000
            //   897c2420             | mov                 dword ptr [esp + 0x28], ebx
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [esp + 0x20], edi
            //   7914                 | test                eax, eax

        $sequence_27 = { 488905???????? 4a8d0c10 eb0d 488b02 488905???????? 488b0a 488b05???????? }
            // n = 7, score = 100
            //   488905????????       |                     
            //   4a8d0c10             | dec                 esp
            //   eb0d                 | mov                 dword ptr [eax], ebx
            //   488b02               | dec                 esp
            //   488905????????       |                     
            //   488b0a               | mov                 dword ptr [ecx + 8], ebx
            //   488b05????????       |                     

        $sequence_28 = { 6232 27 0149bc 2ec9 }
            // n = 4, score = 100
            //   6232                 | bound               esi, qword ptr [edx]
            //   27                   | daa                 
            //   0149bc               | add                 dword ptr [ecx - 0x44], ecx
            //   2ec9                 | leave               

        $sequence_29 = { 8bec 23db 16 23c9 59 }
            // n = 5, score = 100
            //   8bec                 | mov                 ebp, esp
            //   23db                 | and                 ebx, ebx
            //   16                   | push                ss
            //   23c9                 | and                 ecx, ecx
            //   59                   | pop                 ecx

        $sequence_30 = { d147f0 79f4 28f8 8fc1 }
            // n = 4, score = 100
            //   d147f0               | rol                 dword ptr [edi - 0x10], 1
            //   79f4                 | jns                 0xfffffff6
            //   28f8                 | sub                 al, bh
            //   8fc1                 | pop                 ecx

        $sequence_31 = { ae d7 b81fe9f60b e8???????? 7660 b85c8e6189 }
            // n = 6, score = 100
            //   ae                   | scasb               al, byte ptr es:[edi]
            //   d7                   | xlatb               
            //   b81fe9f60b           | mov                 eax, 0xbf6e91f
            //   e8????????           |                     
            //   7660                 | jbe                 0x62
            //   b85c8e6189           | mov                 eax, 0x89618e5c

        $sequence_32 = { 488b4128 4883c120 488905???????? 48890d???????? 4c8918 4c895908 33c0 }
            // n = 7, score = 100
            //   488b4128             | jns                 0x16
            //   4883c120             | dec                 eax
            //   488905????????       |                     
            //   48890d????????       |                     
            //   4c8918               | mov                 eax, dword ptr [ecx + 0x28]
            //   4c895908             | dec                 eax
            //   33c0                 | add                 ecx, 0x20

        $sequence_33 = { 488bcf ff15???????? 4c8d5c2470 8bc3 498b5b30 498b6b38 498b7348 }
            // n = 7, score = 100
            //   488bcf               | xor                 eax, eax
            //   ff15????????         |                     
            //   4c8d5c2470           | dec                 edx
            //   8bc3                 | lea                 ecx, [eax + edx]
            //   498b5b30             | jmp                 0xf
            //   498b6b38             | dec                 eax
            //   498b7348             | mov                 eax, dword ptr [edx]

        $sequence_34 = { 83440c0404 23c9 8be5 5d c20400 95 367a3e }
            // n = 7, score = 100
            //   83440c0404           | add                 dword ptr [esp + ecx + 4], 4
            //   23c9                 | and                 ecx, ecx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   95                   | xchg                eax, ebp
            //   367a3e               | jp                  0x41

        $sequence_35 = { 4c397500 741e 837d04ff 750f 837d00ff 7512 488b4308 }
            // n = 7, score = 100
            //   4c397500             | lea                 ebx, [esp + 0x70]
            //   741e                 | mov                 eax, ebx
            //   837d04ff             | dec                 ecx
            //   750f                 | mov                 ebx, dword ptr [ebx + 0x30]
            //   837d00ff             | dec                 ecx
            //   7512                 | mov                 ebp, dword ptr [ebx + 0x38]
            //   488b4308             | dec                 ecx

    condition:
        7 of them and filesize < 548864
}