rule win_royal_dns_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.royal_dns."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.royal_dns"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c 56 83c30d 8d85d8fcffff 53 50 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   83c30d               | add                 ebx, 0xd
            //   8d85d8fcffff         | lea                 eax, [ebp - 0x328]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_1 = { 83c404 83bdb1f7ffff64 8b8dbbf7ffff 8d70f1 7559 83f964 7554 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   83bdb1f7ffff64       | cmp                 dword ptr [ebp - 0x84f], 0x64
            //   8b8dbbf7ffff         | mov                 ecx, dword ptr [ebp - 0x845]
            //   8d70f1               | lea                 esi, [eax - 0xf]
            //   7559                 | jne                 0x5b
            //   83f964               | cmp                 ecx, 0x64
            //   7554                 | jne                 0x56

        $sequence_2 = { f3a5 e8???????? 83c40c b908000000 }
            // n = 4, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   b908000000           | mov                 ecx, 8

        $sequence_3 = { be???????? 8d7dd8 f3a5 83c40c 6a01 a4 e8???????? }
            // n = 7, score = 100
            //   be????????           |                     
            //   8d7dd8               | lea                 edi, [ebp - 0x28]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   83c40c               | add                 esp, 0xc
            //   6a01                 | push                1
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   e8????????           |                     

        $sequence_4 = { 0fb65c0602 c1ea07 03db 0bd3 83e21f 0fb69248132500 885104 }
            // n = 7, score = 100
            //   0fb65c0602           | movzx               ebx, byte ptr [esi + eax + 2]
            //   c1ea07               | shr                 edx, 7
            //   03db                 | add                 ebx, ebx
            //   0bd3                 | or                  edx, ebx
            //   83e21f               | and                 edx, 0x1f
            //   0fb69248132500       | movzx               edx, byte ptr [edx + 0x251348]
            //   885104               | mov                 byte ptr [ecx + 4], dl

        $sequence_5 = { 8d85c0feffff 6a00 50 c785b0feffffa9ea6152 c785b4feffffe7a5db56 }
            // n = 5, score = 100
            //   8d85c0feffff         | lea                 eax, [ebp - 0x140]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c785b0feffffa9ea6152     | mov    dword ptr [ebp - 0x150], 0x5261eaa9
            //   c785b4feffffe7a5db56     | mov    dword ptr [ebp - 0x14c], 0x56dba5e7

        $sequence_6 = { 7416 83fe04 7511 8b95bff7ffff 89957cf1ffff e9???????? 85c9 }
            // n = 7, score = 100
            //   7416                 | je                  0x18
            //   83fe04               | cmp                 esi, 4
            //   7511                 | jne                 0x13
            //   8b95bff7ffff         | mov                 edx, dword ptr [ebp - 0x841]
            //   89957cf1ffff         | mov                 dword ptr [ebp - 0xe84], edx
            //   e9????????           |                     
            //   85c9                 | test                ecx, ecx

        $sequence_7 = { 6888130000 ff15???????? 4e 75f2 68e4000000 8d85c0f5ffff 6a00 }
            // n = 7, score = 100
            //   6888130000           | push                0x1388
            //   ff15????????         |                     
            //   4e                   | dec                 esi
            //   75f2                 | jne                 0xfffffff4
            //   68e4000000           | push                0xe4
            //   8d85c0f5ffff         | lea                 eax, [ebp - 0xa40]
            //   6a00                 | push                0

        $sequence_8 = { 393d???????? 7c11 6860ea0000 ffd6 c705????????00000000 68b80b0000 }
            // n = 6, score = 100
            //   393d????????         |                     
            //   7c11                 | jl                  0x13
            //   6860ea0000           | push                0xea60
            //   ffd6                 | call                esi
            //   c705????????00000000     |     
            //   68b80b0000           | push                0xbb8

        $sequence_9 = { 772a ff248590162400 6a01 6a03 }
            // n = 4, score = 100
            //   772a                 | ja                  0x2c
            //   ff248590162400       | jmp                 dword ptr [eax*4 + 0x241690]
            //   6a01                 | push                1
            //   6a03                 | push                3

    condition:
        7 of them and filesize < 204800
}