rule win_royal_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.royal_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.royal_ransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4c8d059b3b1400 ba8f000000 e9???????? 488b4608 8b08 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d059b3b1400       | xor                 ecx, ecx
            //   ba8f000000           | mov                 dword ptr [esp + 0x20], esi
            //   e9????????           |                     
            //   488b4608             | dec                 ebp
            //   8b08                 | mov                 eax, edi
            //   e8????????           |                     

        $sequence_1 = { 803d????????00 754c 488d0d5c220d00 48890d???????? 488d050e1f0d00 488d0d37210d00 488905???????? }
            // n = 7, score = 100
            //   803d????????00       |                     
            //   754c                 | lea                 edx, [edi + 0x72]
            //   488d0d5c220d00       | lea                 ecx, [edi + 6]
            //   48890d????????       |                     
            //   488d050e1f0d00       | mov                 edx, 0x3ca
            //   488d0d37210d00       | dec                 eax
            //   488905????????       |                     

        $sequence_2 = { e8???????? 482be0 488bfa 488bd9 4885c9 747e 488d156abf0600 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   482be0               | dec                 esp
            //   488bfa               | lea                 eax, [0x17adf2]
            //   488bd9               | lea                 edx, [ebp + 0x7d]
            //   4885c9               | dec                 eax
            //   747e                 | lea                 ecx, [0x17ae00]
            //   488d156abf0600       | dec                 esp

        $sequence_3 = { 85c0 0f450d???????? 85c9 7411 488d0d31212400 e8???????? 4885c0 }
            // n = 7, score = 100
            //   85c0                 | shl                 edx, 8
            //   0f450d????????       |                     
            //   85c9                 | ret                 
            //   7411                 | bt                  ecx, 8
            //   488d0d31212400       | jae                 0x1130
            //   e8????????           |                     
            //   4885c0               | dec                 esp

        $sequence_4 = { e8???????? 4c8d0503171400 8d562b 488d0d09171400 e8???????? 4533c0 8d4e10 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d0503171400       | inc                 dword ptr [ecx + 0x470]
            //   8d562b               | cmp                 dword ptr [ecx + 0x470], 2
            //   488d0d09171400       | je                  0x92a
            //   e8????????           |                     
            //   4533c0               | dec                 esp
            //   8d4e10               | lea                 esi, [0xc176b]

        $sequence_5 = { c3 e8???????? 4c8d0553bd1400 ba8f010000 488d0d2fbd1400 e8???????? 4533c0 }
            // n = 7, score = 100
            //   c3                   | inc                 ecx
            //   e8????????           |                     
            //   4c8d0553bd1400       | mov                 eax, 0x12
            //   ba8f010000           | dec                 eax
            //   488d0d2fbd1400       | lea                 edx, [0xfa82d]
            //   e8????????           |                     
            //   4533c0               | inc                 ecx

        $sequence_6 = { e8???????? 397010 0f84ccfeffff e8???????? 4c8d052eb91400 ba66000000 488d0deab81400 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   397010               | mov                 edx, 0x62
            //   0f84ccfeffff         | test                eax, eax
            //   e8????????           |                     
            //   4c8d052eb91400       | jne                 0xe16
            //   ba66000000           | dec                 esp
            //   488d0deab81400       | lea                 eax, [0x15b5fb]

        $sequence_7 = { 754c e8???????? 4c8d05aeb81600 bae9000000 488d0d8ab81600 e8???????? 4533c0 }
            // n = 7, score = 100
            //   754c                 | mov                 edx, 0x7a
            //   e8????????           |                     
            //   4c8d05aeb81600       | dec                 eax
            //   bae9000000           | lea                 ecx, [0x172c59]
            //   488d0d8ab81600       | inc                 ebp
            //   e8????????           |                     
            //   4533c0               | xor                 eax, eax

        $sequence_8 = { e8???????? 4c8d0533510e00 bac1010000 488d0da7500e00 e8???????? 4533c0 8d4f39 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d0533510e00       | add                 ebx, ecx
            //   bac1010000           | inc                 ecx
            //   488d0da7500e00       | mov                 byte ptr [edx], bl
            //   e8????????           |                     
            //   4533c0               | shr                 ebx, 8
            //   8d4f39               | sub                 esi, 1

        $sequence_9 = { c3 49ff80c0000000 488bcb 488b4308 8b10 e8???????? b801000000 }
            // n = 7, score = 100
            //   c3                   | xor                 esi, esi
            //   49ff80c0000000       | dec                 esp
            //   488bcb               | mov                 dword ptr [esp + 0x30], edi
            //   488b4308             | test                eax, eax
            //   8b10                 | jne                 0x1d77
            //   e8????????           |                     
            //   b801000000           | xor                 ecx, ecx

    condition:
        7 of them and filesize < 6235136
}