rule win_ruckguv_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ruckguv."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ruckguv"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750f 56 50 53 }
            // n = 4, score = 200
            //   750f                 | jne                 0x11
            //   56                   | push                esi
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_1 = { 50 8d4640 50 8d4340 50 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   8d4640               | lea                 eax, [esi + 0x40]
            //   50                   | push                eax
            //   8d4340               | lea                 eax, [ebx + 0x40]
            //   50                   | push                eax

        $sequence_2 = { 51 56 8b7508 8b463c 03c6 }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b463c               | mov                 eax, dword ptr [esi + 0x3c]
            //   03c6                 | add                 eax, esi

        $sequence_3 = { ff75fc ffd0 5f 5e 8bc3 5b }
            // n = 6, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd0                 | call                eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx

        $sequence_4 = { a5 a5 66a5 a4 33f6 56 8d453c }
            // n = 7, score = 200
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi
            //   8d453c               | lea                 eax, [ebp + 0x3c]

        $sequence_5 = { ffd0 8d859cfdffff 50 68???????? }
            // n = 4, score = 200
            //   ffd0                 | call                eax
            //   8d859cfdffff         | lea                 eax, [ebp - 0x264]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_6 = { 884d13 8a8801010000 33ff 884dff 397d0c 763d 53 }
            // n = 7, score = 200
            //   884d13               | mov                 byte ptr [ebp + 0x13], cl
            //   8a8801010000         | mov                 cl, byte ptr [eax + 0x101]
            //   33ff                 | xor                 edi, edi
            //   884dff               | mov                 byte ptr [ebp - 1], cl
            //   397d0c               | cmp                 dword ptr [ebp + 0xc], edi
            //   763d                 | jbe                 0x3f
            //   53                   | push                ebx

        $sequence_7 = { 7908 49 81c900f0ffff 41 0fb7c9 }
            // n = 5, score = 200
            //   7908                 | jns                 0xa
            //   49                   | dec                 ecx
            //   81c900f0ffff         | or                  ecx, 0xfffff000
            //   41                   | inc                 ecx
            //   0fb7c9               | movzx               ecx, cx

        $sequence_8 = { 57 8d8598fcffff 50 8d85a0feffff 68???????? 50 ff555c }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8d8598fcffff         | lea                 eax, [ebp - 0x368]
            //   50                   | push                eax
            //   8d85a0feffff         | lea                 eax, [ebp - 0x160]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff555c               | call                dword ptr [ebp + 0x5c]

        $sequence_9 = { 8d859cfdffff 50 68???????? e8???????? 6814f1f808 }
            // n = 5, score = 200
            //   8d859cfdffff         | lea                 eax, [ebp - 0x264]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   6814f1f808           | push                0x8f8f114

    condition:
        7 of them and filesize < 41024
}