rule win_rugmi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rugmi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rugmi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33db 395d08 0f94c3 8b4518 8b4d08 8908 8bc3 }
            // n = 7, score = 100
            //   33db                 | xor                 ebx, ebx
            //   395d08               | cmp                 dword ptr [ebp + 8], ebx
            //   0f94c3               | sete                bl
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8bc3                 | mov                 eax, ebx

        $sequence_1 = { 8b7704 eb14 85c0 0f8535010000 56 57 e8???????? }
            // n = 7, score = 100
            //   8b7704               | mov                 esi, dword ptr [edi + 4]
            //   eb14                 | jmp                 0x16
            //   85c0                 | test                eax, eax
            //   0f8535010000         | jne                 0x13b
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_2 = { 3bcb 726f 8b7514 8b5d10 8bc1 0bc2 7508 }
            // n = 7, score = 100
            //   3bcb                 | cmp                 ecx, ebx
            //   726f                 | jb                  0x71
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   8bc1                 | mov                 eax, ecx
            //   0bc2                 | or                  eax, edx
            //   7508                 | jne                 0xa

        $sequence_3 = { 7507 b8074c0000 c9 c3 8d45e0 50 68???????? }
            // n = 7, score = 100
            //   7507                 | jne                 9
            //   b8074c0000           | mov                 eax, 0x4c07
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_4 = { 894d08 8d56bc 0f45fa 68???????? 03f9 e8???????? 8b7510 }
            // n = 7, score = 100
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   8d56bc               | lea                 edx, [esi - 0x44]
            //   0f45fa               | cmovne              edi, edx
            //   68????????           |                     
            //   03f9                 | add                 edi, ecx
            //   e8????????           |                     
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]

        $sequence_5 = { 5d c3 837d08ff 0f84b4090000 e9???????? 55 8bec }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   837d08ff             | cmp                 dword ptr [ebp + 8], -1
            //   0f84b4090000         | je                  0x9ba
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_6 = { 395e3c 7520 85ff 0f841c010000 6a0a 68???????? }
            // n = 6, score = 100
            //   395e3c               | cmp                 dword ptr [esi + 0x3c], ebx
            //   7520                 | jne                 0x22
            //   85ff                 | test                edi, edi
            //   0f841c010000         | je                  0x122
            //   6a0a                 | push                0xa
            //   68????????           |                     

        $sequence_7 = { 88834d020000 8b84b350010000 83f8ff 7413 50 53 57 }
            // n = 7, score = 100
            //   88834d020000         | mov                 byte ptr [ebx + 0x24d], al
            //   8b84b350010000       | mov                 eax, dword ptr [ebx + esi*4 + 0x150]
            //   83f8ff               | cmp                 eax, -1
            //   7413                 | je                  0x15
            //   50                   | push                eax
            //   53                   | push                ebx
            //   57                   | push                edi

        $sequence_8 = { 8955e4 c645fc00 8d4dcc e8???????? c745fcffffffff 8d8d70ffffff }
            // n = 6, score = 100
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d8d70ffffff         | lea                 ecx, [ebp - 0x90]

        $sequence_9 = { 56 c687cf0c000000 68???????? e9???????? 6a02 59 6a17 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   c687cf0c000000       | mov                 byte ptr [edi + 0xccf], 0
            //   68????????           |                     
            //   e9????????           |                     
            //   6a02                 | push                2
            //   59                   | pop                 ecx
            //   6a17                 | push                0x17

    condition:
        7 of them and filesize < 950272
}