rule win_rumish_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rumish."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rumish"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8908 8b4a04 894804 8b5208 895008 ebd7 5d }
            // n = 7, score = 100
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b4a04               | mov                 ecx, dword ptr [edx + 4]
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8b5208               | mov                 edx, dword ptr [edx + 8]
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   ebd7                 | jmp                 0xffffffd9
            //   5d                   | pop                 ebp

        $sequence_1 = { c7854cffffff00000000 53 51 52 33c0 0fa2 }
            // n = 6, score = 100
            //   c7854cffffff00000000     | mov    dword ptr [ebp - 0xb4], 0
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   52                   | push                edx
            //   33c0                 | xor                 eax, eax
            //   0fa2                 | cpuid               

        $sequence_2 = { 8b55e4 83ea01 3955a4 7d54 8b45a4 }
            // n = 5, score = 100
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   83ea01               | sub                 edx, 1
            //   3955a4               | cmp                 dword ptr [ebp - 0x5c], edx
            //   7d54                 | jge                 0x56
            //   8b45a4               | mov                 eax, dword ptr [ebp - 0x5c]

        $sequence_3 = { e8???????? 89851cfdffff db851cfdffff dc0d???????? dc35???????? dc05???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   89851cfdffff         | mov                 dword ptr [ebp - 0x2e4], eax
            //   db851cfdffff         | fild                dword ptr [ebp - 0x2e4]
            //   dc0d????????         |                     
            //   dc35????????         |                     
            //   dc05????????         |                     

        $sequence_4 = { 0f87c5000000 8b9524fbffff ff2495c0214100 68???????? 8d8dc0fbffff e8???????? }
            // n = 6, score = 100
            //   0f87c5000000         | ja                  0xcb
            //   8b9524fbffff         | mov                 edx, dword ptr [ebp - 0x4dc]
            //   ff2495c0214100       | jmp                 dword ptr [edx*4 + 0x4121c0]
            //   68????????           |                     
            //   8d8dc0fbffff         | lea                 ecx, [ebp - 0x440]
            //   e8????????           |                     

        $sequence_5 = { db8590f6ffff d9e8 dec9 d99d8cf6ffff d9858cf6ffff 51 d91c24 }
            // n = 7, score = 100
            //   db8590f6ffff         | fild                dword ptr [ebp - 0x970]
            //   d9e8                 | fld1                
            //   dec9                 | fmulp               st(1)
            //   d99d8cf6ffff         | fstp                dword ptr [ebp - 0x974]
            //   d9858cf6ffff         | fld                 dword ptr [ebp - 0x974]
            //   51                   | push                ecx
            //   d91c24               | fstp                dword ptr [esp]

        $sequence_6 = { c745fcffffffff 8d4dc0 e8???????? 8b852cfdffff e9???????? e8???????? 898508fdffff }
            // n = 7, score = 100
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     
            //   8b852cfdffff         | mov                 eax, dword ptr [ebp - 0x2d4]
            //   e9????????           |                     
            //   e8????????           |                     
            //   898508fdffff         | mov                 dword ptr [ebp - 0x2f8], eax

        $sequence_7 = { ff15???????? 8b95a0fdffff 89956cfdffff c785b0fdffff00000000 c78544fdffff00000000 eb0f 8b8544fdffff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b95a0fdffff         | mov                 edx, dword ptr [ebp - 0x260]
            //   89956cfdffff         | mov                 dword ptr [ebp - 0x294], edx
            //   c785b0fdffff00000000     | mov    dword ptr [ebp - 0x250], 0
            //   c78544fdffff00000000     | mov    dword ptr [ebp - 0x2bc], 0
            //   eb0f                 | jmp                 0x11
            //   8b8544fdffff         | mov                 eax, dword ptr [ebp - 0x2bc]

        $sequence_8 = { d99d54ffffff d98554ffffff 51 d91c24 e8???????? 83c404 dc1d???????? }
            // n = 7, score = 100
            //   d99d54ffffff         | fstp                dword ptr [ebp - 0xac]
            //   d98554ffffff         | fld                 dword ptr [ebp - 0xac]
            //   51                   | push                ecx
            //   d91c24               | fstp                dword ptr [esp]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   dc1d????????         |                     

        $sequence_9 = { 894de4 8b45e4 c700???????? 8b4de4 c7410400000000 8b55e4 c7420800000000 }
            // n = 7, score = 100
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   c700????????         |                     
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   c7410400000000       | mov                 dword ptr [ecx + 4], 0
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   c7420800000000       | mov                 dword ptr [edx + 8], 0

    condition:
        7 of them and filesize < 770048
}