rule win_runningrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.runningrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.runningrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 ff15???????? 56 ff15???????? 8b8c2418010000 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b8c2418010000       | mov                 ecx, dword ptr [esp + 0x118]

        $sequence_1 = { 891481 ff4608 e9???????? 83fa12 750a c744242c07000000 eb07 }
            // n = 7, score = 100
            //   891481               | mov                 dword ptr [ecx + eax*4], edx
            //   ff4608               | inc                 dword ptr [esi + 8]
            //   e9????????           |                     
            //   83fa12               | cmp                 edx, 0x12
            //   750a                 | jne                 0xc
            //   c744242c07000000     | mov                 dword ptr [esp + 0x2c], 7
            //   eb07                 | jmp                 9

        $sequence_2 = { 5d 83c408 c3 8b442434 8b4c242c 56 }
            // n = 6, score = 100
            //   5d                   | pop                 ebp
            //   83c408               | add                 esp, 8
            //   c3                   | ret                 
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   56                   | push                esi

        $sequence_3 = { dec1 dee9 def9 dc0d???????? }
            // n = 4, score = 100
            //   dec1                 | faddp               st(1)
            //   dee9                 | fsubp               st(1)
            //   def9                 | fdivp               st(1)
            //   dc0d????????         |                     

        $sequence_4 = { 50 03cb 51 e8???????? 8b542428 0fb74206 47 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   03cb                 | add                 ecx, ebx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   0fb74206             | movzx               eax, word ptr [edx + 6]
            //   47                   | inc                 edi

        $sequence_5 = { f3a4 ff15???????? 5f 5e 5d 33c0 }
            // n = 6, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 8b4764 50 e8???????? 33c0 83c404 8bcf 894764 }
            // n = 7, score = 100
            //   8b4764               | mov                 eax, dword ptr [edi + 0x64]
            //   50                   | push                eax
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   83c404               | add                 esp, 4
            //   8bcf                 | mov                 ecx, edi
            //   894764               | mov                 dword ptr [edi + 0x64], eax

        $sequence_7 = { 03c8 40 8a0c29 884c03ff 8b4e04 }
            // n = 5, score = 100
            //   03c8                 | add                 ecx, eax
            //   40                   | inc                 eax
            //   8a0c29               | mov                 cl, byte ptr [ecx + ebp]
            //   884c03ff             | mov                 byte ptr [ebx + eax - 1], cl
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]

        $sequence_8 = { 8be8 83c404 83fdfd 7515 }
            // n = 4, score = 100
            //   8be8                 | mov                 ebp, eax
            //   83c404               | add                 esp, 4
            //   83fdfd               | cmp                 ebp, -3
            //   7515                 | jne                 0x17

        $sequence_9 = { 8dbc24a4010000 f3ab 8d8c2408020000 51 }
            // n = 4, score = 100
            //   8dbc24a4010000       | lea                 edi, [esp + 0x1a4]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d8c2408020000       | lea                 ecx, [esp + 0x208]
            //   51                   | push                ecx

        $sequence_10 = { 83c204 89542420 3bce 741f 8b948c8c000000 8b9c242c010000 }
            // n = 6, score = 100
            //   83c204               | add                 edx, 4
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   3bce                 | cmp                 ecx, esi
            //   741f                 | je                  0x21
            //   8b948c8c000000       | mov                 edx, dword ptr [esp + ecx*4 + 0x8c]
            //   8b9c242c010000       | mov                 ebx, dword ptr [esp + 0x12c]

        $sequence_11 = { 6a00 6a00 8b82a8000000 50 68???????? 6a00 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8b82a8000000         | mov                 eax, dword ptr [edx + 0xa8]
            //   50                   | push                eax
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_12 = { 50 e8???????? 8b5644 68a2aedeac 68ce9a32f7 68c9600000 52 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b5644               | mov                 edx, dword ptr [esi + 0x44]
            //   68a2aedeac           | push                0xacdeaea2
            //   68ce9a32f7           | push                0xf7329ace
            //   68c9600000           | push                0x60c9
            //   52                   | push                edx

        $sequence_13 = { 7336 8d642400 837c241c00 0f84cc020000 0fb613 ff4c241c }
            // n = 6, score = 100
            //   7336                 | jae                 0x38
            //   8d642400             | lea                 esp, [esp]
            //   837c241c00           | cmp                 dword ptr [esp + 0x1c], 0
            //   0f84cc020000         | je                  0x2d2
            //   0fb613               | movzx               edx, byte ptr [ebx]
            //   ff4c241c             | dec                 dword ptr [esp + 0x1c]

        $sequence_14 = { 8bd1 83e201 d1e9 895618 83f903 0f8761060000 }
            // n = 6, score = 100
            //   8bd1                 | mov                 edx, ecx
            //   83e201               | and                 edx, 1
            //   d1e9                 | shr                 ecx, 1
            //   895618               | mov                 dword ptr [esi + 0x18], edx
            //   83f903               | cmp                 ecx, 3
            //   0f8761060000         | ja                  0x667

    condition:
        7 of them and filesize < 275456
}