rule win_ryuk_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ryuk_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ryuk_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcb e8???????? 3bc7 7552 }
            // n = 4, score = 800
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   3bc7                 | cmp                 eax, edi
            //   7552                 | jne                 0x54

        $sequence_1 = { 05???????? 50 8d85b4fdffff 50 e8???????? }
            // n = 5, score = 800
            //   05????????           |                     
            //   50                   | push                eax
            //   8d85b4fdffff         | lea                 eax, [ebp - 0x24c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 8bcb 0f44f2 42 8d7902 }
            // n = 4, score = 800
            //   8bcb                 | mov                 ecx, ebx
            //   0f44f2               | cmove               esi, edx
            //   42                   | inc                 edx
            //   8d7902               | lea                 edi, [ecx + 2]

        $sequence_3 = { 83f801 7410 83ff01 755d }
            // n = 4, score = 800
            //   83f801               | cmp                 eax, 1
            //   7410                 | je                  0x12
            //   83ff01               | cmp                 edi, 1
            //   755d                 | jne                 0x5f

        $sequence_4 = { 8a443706 3c2f 7404 3c2d }
            // n = 4, score = 800
            //   8a443706             | mov                 al, byte ptr [edi + esi + 6]
            //   3c2f                 | cmp                 al, 0x2f
            //   7404                 | je                  6
            //   3c2d                 | cmp                 al, 0x2d

        $sequence_5 = { b9a0860100 f7f9 81c2f8240100 52 ff15???????? }
            // n = 5, score = 800
            //   b9a0860100           | mov                 ecx, 0x186a0
            //   f7f9                 | idiv                ecx
            //   81c2f8240100         | add                 edx, 0x124f8
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_6 = { 668945ec 8945ee 668945f2 8d45e0 50 }
            // n = 5, score = 800
            //   668945ec             | mov                 word ptr [ebp - 0x14], ax
            //   8945ee               | mov                 dword ptr [ebp - 0x12], eax
            //   668945f2             | mov                 word ptr [ebp - 0xe], ax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax

        $sequence_7 = { 81c2f8240100 52 ff15???????? 46 }
            // n = 4, score = 800
            //   81c2f8240100         | add                 edx, 0x124f8
            //   52                   | push                edx
            //   ff15????????         |                     
            //   46                   | inc                 esi

        $sequence_8 = { e8???????? 99 b9a0860100 f7f9 81c2f8240100 52 ff15???????? }
            // n = 7, score = 800
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b9a0860100           | mov                 ecx, 0x186a0
            //   f7f9                 | idiv                ecx
            //   81c2f8240100         | add                 edx, 0x124f8
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_9 = { 75f4 a1???????? 8907 eb38 }
            // n = 4, score = 800
            //   75f4                 | jne                 0xfffffff6
            //   a1????????           |                     
            //   8907                 | mov                 dword ptr [edi], eax
            //   eb38                 | jmp                 0x3a

    condition:
        7 of them and filesize < 368640
}