rule win_sadbridge_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sadbridge."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sadbridge"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48c7435800000000 4c89e1 48c7436000000000 48c7436800000000 48c7437000020000 66894378 }
            // n = 6, score = 100
            //   48c7435800000000     | mov                 ecx, eax
            //   4c89e1               | dec                 eax
            //   48c7436000000000     | mov                 eax, dword ptr [esp + 0x68]
            //   48c7436800000000     | dec                 eax
            //   48c7437000020000     | mov                 edx, dword ptr [eax - 0x18]
            //   66894378             | dec                 eax

        $sequence_1 = { 31d2 83e001 05ffffff7f 8944245c 41f7f5 89442458 488d869c000000 }
            // n = 7, score = 100
            //   31d2                 | cmp                 ecx, eax
            //   83e001               | xor                 eax, eax
            //   05ffffff7f           | nop                 word ptr [eax + eax]
            //   8944245c             | dec                 eax
            //   41f7f5               | mov                 edi, dword ptr [esp + 0x128]
            //   89442458             | mov                 dword ptr [edi], eax
            //   488d869c000000       | mov                 byte ptr [edi], 0

        $sequence_2 = { 0f8568fcffff 488b4570 448920 e9???????? 488b01 ff5048 83f8ff }
            // n = 7, score = 100
            //   0f8568fcffff         | dec                 ebp
            //   488b4570             | test                ebp, ebp
            //   448920               | setne               dl
            //   e9????????           |                     
            //   488b01               | inc                 eax
            //   ff5048               | and                 dl, bh
            //   83f8ff               | jne                 0x6f9

        $sequence_3 = { 53 4883ec28 4889542478 4989cd 4c89842480000000 4839d1 0f843f010000 }
            // n = 7, score = 100
            //   53                   | mov                 ebx, ecx
            //   4883ec28             | dec                 eax
            //   4889542478           | lea                 ecx, [0xb67931]
            //   4989cd               | dec                 eax
            //   4c89842480000000     | mov                 edx, dword ptr [ebx]
            //   4839d1               | dec                 eax
            //   0f843f010000         | mov                 ecx, dword ptr [edx + 8]

        $sequence_4 = { 400f94c6 4885c0 0f94c2 4809c1 0f8489020000 8b842498000000 4531f6 }
            // n = 7, score = 100
            //   400f94c6             | dec                 eax
            //   4885c0               | mov                 ebx, eax
            //   0f94c2               | cmp                 al, 0x61
            //   4809c1               | jne                 0x215
            //   0f8489020000         | mov                 eax, 0x61
            //   8b842498000000       | mov                 word ptr [ecx], ax
            //   4531f6               | movzx               eax, byte ptr [edx]

        $sequence_5 = { 31d0 29d0 83f864 0f9fc0 0fb6c0 4883c428 5b }
            // n = 7, score = 100
            //   31d0                 | mov                 eax, dword ptr [ebp]
            //   29d0                 | dec                 eax
            //   83f864               | mov                 dword ptr [esp + 0x58], edx
            //   0f9fc0               | dec                 esp
            //   0fb6c0               | mov                 ecx, ebp
            //   4883c428             | call                dword ptr [eax + 0x48]
            //   5b                   | xor                 eax, eax

        $sequence_6 = { 49c744240800000000 498d4c2438 49c744241000000000 488d7810 49893c24 49c744241800000000 49c744242000000000 }
            // n = 7, score = 100
            //   49c744240800000000     | mov    eax, dword ptr [esp + 0x10]
            //   498d4c2438           | dec                 eax
            //   49c744241000000000     | cmp    ebx, eax
            //   488d7810             | ja                  0x6a6
            //   49893c24             | dec                 ebp
            //   49c744241800000000     | test    eax, eax
            //   49c744242000000000     | dec    ecx

        $sequence_7 = { 41ba01000000 4885c9 741e 488b4110 483b4118 0f83ad020000 0fb700 }
            // n = 7, score = 100
            //   41ba01000000         | arpl                sp, ax
            //   4885c9               | inc                 esp
            //   741e                 | mov                 dword ptr [esp + 0x50], esp
            //   488b4110             | dec                 eax
            //   483b4118             | mov                 dword ptr [esp + 0x30], eax
            //   0f83ad020000         | dec                 eax
            //   0fb700               | lea                 eax, [esp + 0x87]

        $sequence_8 = { 488b4c2470 448b6c2478 4885c9 740a 4183fdff 0f84a7030000 4084ff }
            // n = 7, score = 100
            //   488b4c2470           | dec                 ecx
            //   448b6c2478           | mov                 eax, esi
            //   4885c9               | dec                 eax
            //   740a                 | mov                 eax, dword ptr [ecx]
            //   4183fdff             | call                dword ptr [eax + 0x60]
            //   0f84a7030000         | dec                 eax
            //   4084ff               | cmp                 esi, eax

        $sequence_9 = { 745c 498b4c2410 4839cb 7732 4d85c0 7416 4a8d0c50 }
            // n = 7, score = 100
            //   745c                 | mov                 eax, ebx
            //   498b4c2410           | dec                 esp
            //   4839cb               | mov                 edx, ecx
            //   7732                 | nop                 dword ptr [eax]
            //   4d85c0               | je                  0x69
            //   7416                 | inc                 ebx
            //   4a8d0c50             | movzx               ecx, word ptr [eax + edx*2]

    condition:
        7 of them and filesize < 25882624
}