rule win_safenet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.safenet."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.safenet"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4db4 50 c645fc01 e8???????? 8b4d08 }
            // n = 5, score = 100
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   50                   | push                eax
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_1 = { ff15???????? eb5a ff75fc ff15???????? }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   eb5a                 | jmp                 0x5c
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     

        $sequence_2 = { 8b45fc 3bc3 7504 c6461401 }
            // n = 4, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   3bc3                 | cmp                 eax, ebx
            //   7504                 | jne                 6
            //   c6461401             | mov                 byte ptr [esi + 0x14], 1

        $sequence_3 = { 51 8d8d7cffffff ff7634 51 50 ffd3 85c0 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8d8d7cffffff         | lea                 ecx, [ebp - 0x84]
            //   ff7634               | push                dword ptr [esi + 0x34]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax

        $sequence_4 = { 68???????? 57 ff15???????? 3bc6 7505 83ceff }
            // n = 6, score = 100
            //   68????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   3bc6                 | cmp                 eax, esi
            //   7505                 | jne                 7
            //   83ceff               | or                  esi, 0xffffffff

        $sequence_5 = { 3b1d???????? 0f8315010000 8bc3 8bcb c1f805 83e11f 8b048540174100 }
            // n = 7, score = 100
            //   3b1d????????         |                     
            //   0f8315010000         | jae                 0x11b
            //   8bc3                 | mov                 eax, ebx
            //   8bcb                 | mov                 ecx, ebx
            //   c1f805               | sar                 eax, 5
            //   83e11f               | and                 ecx, 0x1f
            //   8b048540174100       | mov                 eax, dword ptr [eax*4 + 0x411740]

        $sequence_6 = { 50 ff7638 57 ff7618 ff55f8 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff7638               | push                dword ptr [esi + 0x38]
            //   57                   | push                edi
            //   ff7618               | push                dword ptr [esi + 0x18]
            //   ff55f8               | call                dword ptr [ebp - 8]

        $sequence_7 = { 8d34b5d0d84000 83c00c 3bc6 7305 395004 }
            // n = 5, score = 100
            //   8d34b5d0d84000       | lea                 esi, [esi*4 + 0x40d8d0]
            //   83c00c               | add                 eax, 0xc
            //   3bc6                 | cmp                 eax, esi
            //   7305                 | jae                 7
            //   395004               | cmp                 dword ptr [eax + 4], edx

        $sequence_8 = { ff750c e8???????? ff75ec e8???????? ff75e8 e8???????? }
            // n = 6, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   e8????????           |                     

        $sequence_9 = { c745bc3c000000 c745c040040000 ff15???????? 8945c4 8d85b4fdffff 8945cc }
            // n = 6, score = 100
            //   c745bc3c000000       | mov                 dword ptr [ebp - 0x44], 0x3c
            //   c745c040040000       | mov                 dword ptr [ebp - 0x40], 0x440
            //   ff15????????         |                     
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   8d85b4fdffff         | lea                 eax, [ebp - 0x24c]
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax

    condition:
        7 of them and filesize < 262144
}