rule win_saigon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.saigon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.saigon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 0f85f4000000 488b0d???????? 33d2 41b800100000 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85c0                 | lea                 ecx, [ebx + edi*2]
            //   0f85f4000000         | mov                 dword ptr [esp + 0x28], ecx
            //   488b0d????????       |                     
            //   33d2                 | dec                 ebp
            //   41b800100000         | mov                 ecx, edi

        $sequence_1 = { 33db 488bf2 4533c9 448d4303 }
            // n = 4, score = 200
            //   33db                 | mov                 ebx, dword ptr [esp + 0x58]
            //   488bf2               | inc                 ebp
            //   4533c9               | test                ebx, ebx
            //   448d4303             | xor                 ecx, ecx

        $sequence_2 = { 418bd5 89542440 4533c9 4533c0 488bc8 895c2420 }
            // n = 6, score = 200
            //   418bd5               | inc                 ecx
            //   89542440             | bswap               ecx
            //   4533c9               | mov                 edx, dword ptr [esp + 0x50]
            //   4533c0               | and                 dword ptr [esp + 0x28], ebx
            //   488bc8               | dec                 esp
            //   895c2420             | lea                 ecx, [esp + 0x50]

        $sequence_3 = { 0f859d000000 488bcb ff15???????? 488b0d???????? 33d2 448d440034 ff15???????? }
            // n = 7, score = 200
            //   0f859d000000         | mov                 edi, 0x26
            //   488bcb               | cmp                 eax, esi
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   33d2                 | cmove               eax, edi
            //   448d440034           | mov                 ebp, eax
            //   ff15????????         |                     

        $sequence_4 = { 488d842470020000 4c8d842440050000 488d942490030000 488d8c24c0000000 448bcb 895c2428 }
            // n = 6, score = 200
            //   488d842470020000     | dec                 esp
            //   4c8d842440050000     | lea                 eax, [esp + 0x30]
            //   488d942490030000     | inc                 ecx
            //   488d8c24c0000000     | mov                 ecx, 0x30
            //   448bcb               | dec                 eax
            //   895c2428             | test                eax, eax

        $sequence_5 = { e8???????? 488d8f88000000 ff15???????? f08387b000000001 488d8f88000000 ff15???????? 440fb65f66 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   488d8f88000000       | dec                 ecx
            //   ff15????????         |                     
            //   f08387b000000001     | mov                 ecx, ebp
            //   488d8f88000000       | inc                 esp
            //   ff15????????         |                     
            //   440fb65f66           | mov                 dword ptr [esp + 0x28], esi

        $sequence_6 = { 0f8592000000 f60302 0f8589000000 448b6b08 }
            // n = 4, score = 200
            //   0f8592000000         | dec                 eax
            //   f60302               | mov                 edx, edi
            //   0f8589000000         | je                  0x2b3
            //   448b6b08             | dec                 eax

        $sequence_7 = { 4533c9 488bd0 498bce e8???????? 488b0d???????? 33d2 }
            // n = 6, score = 200
            //   4533c9               | jne                 0x66d
            //   488bd0               | mov                 edx, 0x1000000
            //   498bce               | xor                 ecx, ecx
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   33d2                 | inc                 ebp

        $sequence_8 = { 4885c9 740c 33d2 e8???????? 4c8be0 eb03 4533e4 }
            // n = 7, score = 200
            //   4885c9               | test                ebp, ebp
            //   740c                 | je                  0x121
            //   33d2                 | inc                 ecx
            //   e8????????           |                     
            //   4c8be0               | cmp                 ebx, dword ptr [esp + 0x1c]
            //   eb03                 | ja                  0xbd
            //   4533e4               | inc                 ecx

        $sequence_9 = { ff5038 85c0 781c 488b4c2430 4533c0 }
            // n = 5, score = 200
            //   ff5038               | dec                 esp
            //   85c0                 | mov                 ecx, ebx
            //   781c                 | inc                 ebp
            //   488b4c2430           | xor                 eax, eax
            //   4533c0               | dec                 eax

    condition:
        7 of them and filesize < 147456
}