rule win_sakula_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sakula_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sakula_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6800010000 6a00 6a00 68???????? }
            // n = 5, score = 300
            //   6a00                 | dec                 eax
            //   6800010000           | mov                 ecx, ebx
            //   6a00                 | dec                 eax
            //   6a00                 | mov                 edx, dword ptr [ebp - 0x29]
            //   68????????           |                     

        $sequence_1 = { b802000000 eb0a f7d8 1bc0 83e0fd }
            // n = 5, score = 200
            //   b802000000           | mov                 eax, dword ptr [ebp + 8]
            //   eb0a                 | add                 eax, dword ptr [ebp - 8]
            //   f7d8                 | mov                 dword ptr [ebp - 4], eax
            //   1bc0                 | cmp                 eax, 0
            //   83e0fd               | je                  0xf9

        $sequence_2 = { 83e103 8d8396000000 f3a4 8bc8 8a10 40 84d2 }
            // n = 7, score = 200
            //   83e103               | push                0x104
            //   8d8396000000         | push                dword ptr [ebp - 0x10]
            //   f3a4                 | mov                 ecx, dword ptr [ebp + 8]
            //   8bc8                 | add                 ecx, dword ptr [ebp - 8]
            //   8a10                 | movsx               edx, byte ptr [ecx]
            //   40                   | cmp                 edx, 0x41
            //   84d2                 | jl                  0x1e

        $sequence_3 = { 33f6 8d4900 ff15???????? 33d2 b914000000 }
            // n = 5, score = 200
            //   33f6                 | push                ebx
            //   8d4900               | push                0
            //   ff15????????         |                     
            //   33d2                 | push                0x100
            //   b914000000           | push                0

        $sequence_4 = { 889c244b010000 48 8d642400 8a4801 40 3acb }
            // n = 6, score = 200
            //   889c244b010000       | push                eax
            //   48                   | mov                 eax, dword ptr [ebp - 8]
            //   8d642400             | add                 eax, 0x28
            //   8a4801               | mov                 byte ptr [eax], 0
            //   40                   | pop                 ebx
            //   3acb                 | push                ebx

        $sequence_5 = { eb05 41 3bce 72dd 8d46ff }
            // n = 5, score = 200
            //   eb05                 | xor                 eax, eax
            //   41                   | push                eax
            //   3bce                 | push                dword ptr [ebp - 4]
            //   72dd                 | push                0x9c
            //   8d46ff               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { 50 6800040000 57 6a02 51 ff15???????? }
            // n = 6, score = 200
            //   50                   | cmp                 eax, 0
            //   6800040000           | je                  0xb4
            //   57                   | mov                 dword ptr [ebp - 0x10], eax
            //   6a02                 | cmp                 eax, 0
            //   51                   | je                  0xed
            //   ff15????????         |                     

        $sequence_7 = { 6a00 6a00 6a00 53 6aff 56 6a00 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | jmp                 7
            //   6a00                 | inc                 ecx
            //   53                   | cmp                 ecx, esi
            //   6aff                 | jb                  0xffffffe1
            //   56                   | lea                 eax, [esi - 1]
            //   6a00                 | push                eax

        $sequence_8 = { 48895c2420 ff15???????? 33d2 488bcb ff15???????? }
            // n = 5, score = 100
            //   48895c2420           | mov                 ecx, esi
            //   ff15????????         |                     
            //   33d2                 | dec                 eax
            //   488bcb               | mov                 ebx, eax
            //   ff15????????         |                     

        $sequence_9 = { 8b45f8 8b5df4 39d8 721e 741c 29d8 0345fc }
            // n = 7, score = 100
            //   8b45f8               | cmp                 eax, esi
            //   8b5df4               | lea                 edi, [esi + 0x2f]
            //   39d8                 | xor                 edx, edx
            //   721e                 | dec                 eax
            //   741c                 | mov                 ecx, eax
            //   29d8                 | inc                 esp
            //   0345fc               | mov                 eax, edi

        $sequence_10 = { 4c8d4dd7 4c8d05791d0000 488d0d8a1d0000 33d2 ff15???????? }
            // n = 5, score = 100
            //   4c8d4dd7             | dec                 eax
            //   4c8d05791d0000       | mov                 ecx, eax
            //   488d0d8a1d0000       | inc                 esp
            //   33d2                 | mov                 eax, edi
            //   ff15????????         |                     

        $sequence_11 = { e8???????? 8b45f0 eb02 31c0 50 ff75fc e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b45f0               | and                 dword ptr [esp + 0x38], 0
            //   eb02                 | dec                 eax
            //   31c0                 | and                 dword ptr [esp + 0x30], 0
            //   50                   | and                 dword ptr [esp + 0x28], 0
            //   ff75fc               | dec                 eax
            //   e8????????           |                     

        $sequence_12 = { 3bc6 745f 4c8d4dcf 4c8d055b1d0000 488d0d7c1f0000 }
            // n = 5, score = 100
            //   3bc6                 | mov                 ecx, esi
            //   745f                 | dec                 eax
            //   4c8d4dcf             | mov                 ebx, eax
            //   4c8d055b1d0000       | dec                 eax
            //   488d0d7c1f0000       | and                 dword ptr [esp + 0x38], 0

        $sequence_13 = { 8b4d08 034df8 0fbe11 83fa41 7c16 8b4508 0345f8 }
            // n = 7, score = 100
            //   8b4d08               | push                0
            //   034df8               | push                0
            //   0fbe11               | cmp                 eax, 0
            //   83fa41               | je                  0x37
            //   7c16                 | mov                 ebx, dword ptr [ebp + 8]
            //   8b4508               | mov                 ecx, dword ptr [ebp - 0xc]
            //   0345f8               | mov                 eax, dword ptr [ecx + 0x14]

        $sequence_14 = { 488bd8 4885c0 0f84d3000000 8d7e2f 33d2 488bc8 448bc7 }
            // n = 7, score = 100
            //   488bd8               | dec                 eax
            //   4885c0               | mov                 ebx, eax
            //   0f84d3000000         | dec                 eax
            //   8d7e2f               | test                eax, eax
            //   33d2                 | je                  0xd9
            //   488bc8               | lea                 edi, [esi + 0x2f]
            //   448bc7               | xor                 edx, edx

        $sequence_15 = { e8???????? 83f800 7405 8b45ec }
            // n = 4, score = 100
            //   e8????????           |                     
            //   83f800               | dec                 eax
            //   7405                 | mov                 ecx, esi
            //   8b45ec               | dec                 eax

        $sequence_16 = { ff15???????? 488bce 488bd8 ff15???????? 488364243800 488364243000 4c8bc6 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488bce               | dec                 esp
            //   488bd8               | lea                 ecx, [ebp - 0x29]
            //   ff15????????         |                     
            //   488364243800         | dec                 esp
            //   488364243000         | lea                 eax, [0x1d79]
            //   4c8bc6               | dec                 eax

        $sequence_17 = { ba14008410 488b01 ff5028 3bc6 747d }
            // n = 5, score = 100
            //   ba14008410           | dec                 eax
            //   488b01               | and                 dword ptr [esp + 0x30], 0
            //   ff5028               | dec                 esp
            //   3bc6                 | mov                 eax, esi
            //   747d                 | dec                 eax

        $sequence_18 = { 488b55d7 488b01 488364242000 4c8d0d240f0000 ff9080000000 3bc6 }
            // n = 6, score = 100
            //   488b55d7             | dec                 esp
            //   488b01               | mov                 eax, esi
            //   488364242000         | cmp                 eax, esi
            //   4c8d0d240f0000       | je                  0x66
            //   ff9080000000         | dec                 esp
            //   3bc6                 | lea                 ecx, [ebp - 0x31]

        $sequence_19 = { 8945f0 83f800 0f84e7000000 6804010000 ff75f0 }
            // n = 5, score = 100
            //   8945f0               | je                  0x59
            //   83f800               | dec                 eax
            //   0f84e7000000         | mov                 ecx, dword ptr [ebp - 0x39]
            //   6804010000           | push                0
            //   ff75f0               | push                0x100

        $sequence_20 = { 83f800 742e 8b5d08 8b4df4 8b4114 8903 8b4110 }
            // n = 7, score = 100
            //   83f800               | dec                 eax
            //   742e                 | mov                 eax, dword ptr [ecx]
            //   8b5d08               | dec                 eax
            //   8b4df4               | and                 dword ptr [esp + 0x20], 0
            //   8b4114               | dec                 esp
            //   8903                 | lea                 ecx, [0xf24]
            //   8b4110               | call                dword ptr [eax + 0x80]

        $sequence_21 = { 488bce ff15???????? 488364243800 488364243000 8364242800 488364242000 448bc8 }
            // n = 7, score = 100
            //   488bce               | mov                 edx, 0x10840014
            //   ff15????????         |                     
            //   488364243800         | dec                 eax
            //   488364243000         | mov                 eax, dword ptr [ecx]
            //   8364242800           | call                dword ptr [eax + 0x28]
            //   488364242000         | cmp                 eax, esi
            //   448bc8               | je                  0x87

        $sequence_22 = { 689c000000 e8???????? 8945fc 83f800 0f84ab000000 }
            // n = 5, score = 100
            //   689c000000           | and                 dword ptr [esp + 0x20], 0
            //   e8????????           |                     
            //   8945fc               | inc                 esp
            //   83f800               | mov                 ecx, eax
            //   0f84ab000000         | cmp                 eax, esi

    condition:
        7 of them and filesize < 229376
}