rule win_salgorea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.salgorea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.salgorea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 893424 57 a1???????? 33c5 50 }
            // n = 5, score = 300
            //   893424               | mov                 dword ptr [esp], esi
            //   57                   | push                edi
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   50                   | push                eax

        $sequence_1 = { 81e1ab000000 8b4c2414 f7d3 8b5c2418 53 9d }
            // n = 6, score = 300
            //   81e1ab000000         | and                 ecx, 0xab
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   f7d3                 | not                 ebx
            //   8b5c2418             | mov                 ebx, dword ptr [esp + 0x18]
            //   53                   | push                ebx
            //   9d                   | popfd               

        $sequence_2 = { 66b9ad00 66f7e1 2bcb 80ef1f 59 }
            // n = 5, score = 300
            //   66b9ad00             | mov                 cx, 0xad
            //   66f7e1               | mul                 cx
            //   2bcb                 | sub                 ecx, ebx
            //   80ef1f               | sub                 bh, 0x1f
            //   59                   | pop                 ecx

        $sequence_3 = { e8???????? 8b4510 2bfb 3bc7 0f8302000000 8bf8 3bf1 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   2bfb                 | sub                 edi, ebx
            //   3bc7                 | cmp                 eax, edi
            //   0f8302000000         | jae                 8
            //   8bf8                 | mov                 edi, eax
            //   3bf1                 | cmp                 esi, ecx

        $sequence_4 = { 53 52 8d9c10f47e0000 6699 66c1e303 f6d1 }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   52                   | push                edx
            //   8d9c10f47e0000       | lea                 ebx, [eax + edx + 0x7ef4]
            //   6699                 | cwd                 
            //   66c1e303             | shl                 bx, 3
            //   f6d1                 | not                 cl

        $sequence_5 = { 8d6424fc 8d6424d0 9c 51 f6d1 9c }
            // n = 6, score = 300
            //   8d6424fc             | lea                 esp, [esp - 4]
            //   8d6424d0             | lea                 esp, [esp - 0x30]
            //   9c                   | pushfd              
            //   51                   | push                ecx
            //   f6d1                 | not                 cl
            //   9c                   | pushfd              

        $sequence_6 = { 80e6ee f8 f6d1 52 40 f7d3 8b5c2404 }
            // n = 7, score = 300
            //   80e6ee               | and                 dh, 0xee
            //   f8                   | clc                 
            //   f6d1                 | not                 cl
            //   52                   | push                edx
            //   40                   | inc                 eax
            //   f7d3                 | not                 ebx
            //   8b5c2404             | mov                 ebx, dword ptr [esp + 4]

        $sequence_7 = { 41 6681c1db00 8b4c2410 66c1e804 8b44240c }
            // n = 5, score = 300
            //   41                   | inc                 ecx
            //   6681c1db00           | add                 cx, 0xdb
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   66c1e804             | shr                 ax, 4
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]

        $sequence_8 = { a1???????? 8945cc 8d45cc 3930 }
            // n = 4, score = 200
            //   a1????????           |                     
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   3930                 | cmp                 dword ptr [eax], esi

        $sequence_9 = { 8d943a9979825a 8b7df4 c1c61e 33fe }
            // n = 4, score = 100
            //   8d943a9979825a       | lea                 edx, [edx + edi + 0x5a827999]
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   c1c61e               | rol                 esi, 0x1e
            //   33fe                 | xor                 edi, esi

        $sequence_10 = { 8d9432dcbc1b8f 8b75fc 0b75f8 8b7dfc }
            // n = 4, score = 100
            //   8d9432dcbc1b8f       | lea                 edx, [edx + esi - 0x70e44324]
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   0b75f8               | or                  esi, dword ptr [ebp - 8]
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]

        $sequence_11 = { 8d943a9979825a 8b7df0 337dfc 8bf2 }
            // n = 4, score = 100
            //   8d943a9979825a       | lea                 edx, [edx + edi + 0x5a827999]
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   337dfc               | xor                 edi, dword ptr [ebp - 4]
            //   8bf2                 | mov                 esi, edx

        $sequence_12 = { 8d942498030000 89542428 8b531c 894c2434 }
            // n = 4, score = 100
            //   8d942498030000       | lea                 edx, [esp + 0x398]
            //   89542428             | mov                 dword ptr [esp + 0x28], edx
            //   8b531c               | mov                 edx, dword ptr [ebx + 0x1c]
            //   894c2434             | mov                 dword ptr [esp + 0x34], ecx

        $sequence_13 = { 8d942490000000 e8???????? 8b03 ff7030 }
            // n = 4, score = 100
            //   8d942490000000       | lea                 edx, [esp + 0x90]
            //   e8????????           |                     
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   ff7030               | push                dword ptr [eax + 0x30]

        $sequence_14 = { 8d9432a1ebd96e 8b75e0 3375cc 8955ec }
            // n = 4, score = 100
            //   8d9432a1ebd96e       | lea                 edx, [edx + esi + 0x6ed9eba1]
            //   8b75e0               | mov                 esi, dword ptr [ebp - 0x20]
            //   3375cc               | xor                 esi, dword ptr [ebp - 0x34]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx

        $sequence_15 = { 8d942490000000 e8???????? 85c0 7403 83cfff 8bc7 85ff }
            // n = 7, score = 100
            //   8d942490000000       | lea                 edx, [esp + 0x90]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   83cfff               | or                  edi, 0xffffffff
            //   8bc7                 | mov                 eax, edi
            //   85ff                 | test                edi, edi

    condition:
        7 of them and filesize < 2007040
}