rule win_sality_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sality."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sality"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81f201a00000 668955f8 eb0b 668b45f8 66d1e8 668945f8 }
            // n = 6, score = 400
            //   81f201a00000         | xor                 edx, 0xa001
            //   668955f8             | mov                 word ptr [ebp - 8], dx
            //   eb0b                 | jmp                 0xd
            //   668b45f8             | mov                 ax, word ptr [ebp - 8]
            //   66d1e8               | shr                 ax, 1
            //   668945f8             | mov                 word ptr [ebp - 8], ax

        $sequence_1 = { 6a67 e8???????? 83c410 8b4dfc 03c8 894dfc }
            // n = 6, score = 400
            //   6a67                 | push                0x67
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   03c8                 | add                 ecx, eax
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx

        $sequence_2 = { 51 ff15???????? e9???????? 68581b0000 }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   e9????????           |                     
            //   68581b0000           | push                0x1b58

        $sequence_3 = { 51 ff15???????? eb14 8d95f0fdffff }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   eb14                 | jmp                 0x16
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]

        $sequence_4 = { 81ec88010000 57 c78578feffff00000000 c685fcfeffff00 b940000000 33c0 8dbdfdfeffff }
            // n = 7, score = 400
            //   81ec88010000         | sub                 esp, 0x188
            //   57                   | push                edi
            //   c78578feffff00000000     | mov    dword ptr [ebp - 0x188], 0
            //   c685fcfeffff00       | mov                 byte ptr [ebp - 0x104], 0
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8dbdfdfeffff         | lea                 edi, [ebp - 0x103]

        $sequence_5 = { 6a66 e8???????? 83c410 8b55fc 03d0 8955fc eb37 }
            // n = 7, score = 400
            //   6a66                 | push                0x66
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   03d0                 | add                 edx, eax
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   eb37                 | jmp                 0x39

        $sequence_6 = { 0f8447010000 d1ea 7307 4e }
            // n = 4, score = 400
            //   0f8447010000         | je                  0x14d
            //   d1ea                 | shr                 edx, 1
            //   7307                 | jae                 9
            //   4e                   | dec                 esi

        $sequence_7 = { 51 ff15???????? e8???????? 25ffff0000 }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   e8????????           |                     
            //   25ffff0000           | and                 eax, 0xffff

        $sequence_8 = { 7513 8bc2 83e804 8b00 8906 }
            // n = 5, score = 200
            //   7513                 | jne                 0x15
            //   8bc2                 | mov                 eax, edx
            //   83e804               | sub                 eax, 4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8906                 | mov                 dword ptr [esi], eax

        $sequence_9 = { 8920 896804 8d9dba114000 895808 }
            // n = 4, score = 200
            //   8920                 | mov                 dword ptr [eax], esp
            //   896804               | mov                 dword ptr [eax + 4], ebp
            //   8d9dba114000         | lea                 ebx, [ebp + 0x4011ba]
            //   895808               | mov                 dword ptr [eax + 8], ebx

        $sequence_10 = { 035c240c 33c0 8b3b 037c240c 8b742410 }
            // n = 5, score = 200
            //   035c240c             | add                 ebx, dword ptr [esp + 0xc]
            //   33c0                 | xor                 eax, eax
            //   8b3b                 | mov                 edi, dword ptr [ebx]
            //   037c240c             | add                 edi, dword ptr [esp + 0xc]
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]

        $sequence_11 = { 8bf2 8bf8 50 ff95c5144000 8bc8 f3a6 61 }
            // n = 7, score = 200
            //   8bf2                 | mov                 esi, edx
            //   8bf8                 | mov                 edi, eax
            //   50                   | push                eax
            //   ff95c5144000         | call                dword ptr [ebp + 0x4014c5]
            //   8bc8                 | mov                 ecx, eax
            //   f3a6                 | repe cmpsb          byte ptr [esi], byte ptr es:[edi]
            //   61                   | popal               

        $sequence_12 = { 52 ff953a144000 e8???????? 8907 }
            // n = 4, score = 200
            //   52                   | push                edx
            //   ff953a144000         | call                dword ptr [ebp + 0x40143a]
            //   e8????????           |                     
            //   8907                 | mov                 dword ptr [edi], eax

        $sequence_13 = { 646789260000 8b74240c 66813e4d5a 0f858c000000 03763c 813e50450000 }
            // n = 6, score = 200
            //   646789260000         | mov                 dword ptr fs:[0], esp
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   66813e4d5a           | cmp                 word ptr [esi], 0x5a4d
            //   0f858c000000         | jne                 0x92
            //   03763c               | add                 esi, dword ptr [esi + 0x3c]
            //   813e50450000         | cmp                 dword ptr [esi], 0x4550

        $sequence_14 = { 8b7c2410 b996000000 32c0 f2ae 8bcf }
            // n = 5, score = 200
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   b996000000           | mov                 ecx, 0x96
            //   32c0                 | xor                 al, al
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8bcf                 | mov                 ecx, edi

        $sequence_15 = { 59 83c304 40 3b4218 75e2 3b4218 }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   83c304               | add                 ebx, 4
            //   40                   | inc                 eax
            //   3b4218               | cmp                 eax, dword ptr [edx + 0x18]
            //   75e2                 | jne                 0xffffffe4
            //   3b4218               | cmp                 eax, dword ptr [edx + 0x18]

        $sequence_16 = { 010d???????? 83c004 5f 5e }
            // n = 4, score = 100
            //   010d????????         |                     
            //   83c004               | add                 eax, 4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_17 = { 00fb fb 804880bc 280d???????? }
            // n = 4, score = 100
            //   00fb                 | add                 bl, bh
            //   fb                   | sti                 
            //   804880bc             | or                  byte ptr [eax - 0x80], 0xbc
            //   280d????????         |                     

        $sequence_18 = { 0306 50 8b4e04 8d5608 }
            // n = 4, score = 100
            //   0306                 | add                 eax, dword ptr [esi]
            //   50                   | push                eax
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   8d5608               | lea                 edx, [esi + 8]

        $sequence_19 = { 0306 50 8d5604 e8???????? }
            // n = 4, score = 100
            //   0306                 | add                 eax, dword ptr [esi]
            //   50                   | push                eax
            //   8d5604               | lea                 edx, [esi + 4]
            //   e8????????           |                     

        $sequence_20 = { 0007 7307 c607ff 8ac1 }
            // n = 4, score = 100
            //   0007                 | add                 byte ptr [edi], al
            //   7307                 | jae                 9
            //   c607ff               | mov                 byte ptr [edi], 0xff
            //   8ac1                 | mov                 al, cl

        $sequence_21 = { 014304 c3 53 56 }
            // n = 4, score = 100
            //   014304               | add                 dword ptr [ebx + 4], eax
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_22 = { 0202 7466 0fb77202 8b7a04 }
            // n = 4, score = 100
            //   0202                 | add                 al, byte ptr [edx]
            //   7466                 | je                  0x68
            //   0fb77202             | movzx               esi, word ptr [edx + 2]
            //   8b7a04               | mov                 edi, dword ptr [edx + 4]

        $sequence_23 = { 031e ff7608 ff7604 e8???????? }
            // n = 4, score = 100
            //   031e                 | add                 ebx, dword ptr [esi]
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff7604               | push                dword ptr [esi + 4]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1523712
}