rule win_santa_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.santa_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.santa_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 488d5640 4c89e1 44896c2458 4c897c2460 e8???????? 89c3 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d5640             | mov                 eax, dword ptr [edx + 0x10]
            //   4c89e1               | dec                 esp
            //   44896c2458           | mov                 eax, dword ptr [eax]
            //   4c897c2460           | mov                 ecx, dword ptr [eax + 0x90]
            //   e8????????           |                     
            //   89c3                 | dec                 eax

        $sequence_1 = { 6644894114 488b4918 41c7422407000000 80796700 75b3 80796800 75ad }
            // n = 7, score = 100
            //   6644894114           | inc                 ebp
            //   488b4918             | xor                 ecx, ecx
            //   41c7422407000000     | xor                 edi, edi
            //   80796700             | mov                 byte ptr [esp + 0x60], 0
            //   75b3                 | inc                 ecx
            //   80796800             | mov                 ebp, 0xffffffff
            //   75ad                 | dec                 esp

        $sequence_2 = { c744246cffffffff 488b01 4885c0 7464 4c8d44246c ba0a000000 ff5050 }
            // n = 7, score = 100
            //   c744246cffffffff     | test                ecx, ecx
            //   488b01               | je                  0x8af
            //   4885c0               | test                byte ptr [ebx + 0x6e], 8
            //   7464                 | je                  0x8c7
            //   4c8d44246c           | dec                 eax
            //   ba0a000000           | mov                 edx, dword ptr [ebx + 0x100]
            //   ff5050               | dec                 eax

        $sequence_3 = { e8???????? 89c7 85c0 0f8504f9ffff 8b4334 c7436801000000 4429e0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89c7                 | mov                 dword ptr [esp + 0x28], eax
            //   85c0                 | mov                 dword ptr [esp + 0x20], 4
            //   0f8504f9ffff         | dec                 ebp
            //   8b4334               | arpl                word ptr [esp + 0x90], bp
            //   c7436801000000       | dec                 eax
            //   4429e0               | lea                 eax, [0x12b87f]

        $sequence_4 = { e8???????? 89c3 85c0 0f84fc000000 31db 662e0f1f840000000000 4c89e2 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89c3                 | mov                 edx, 0x61
            //   85c0                 | inc                 ecx
            //   0f84fc000000         | mov                 ecx, 3
            //   31db                 | dec                 eax
            //   662e0f1f840000000000     | lea    eax, [0x10b86a]
            //   4c89e2               | inc                 ebp

        $sequence_5 = { 7371 418b4120 85c0 755f 4881faffffff3f 7768 4883ec38 }
            // n = 7, score = 100
            //   7371                 | push                ebx
            //   418b4120             | dec                 eax
            //   85c0                 | sub                 esp, 0x88
            //   755f                 | mov                 eax, dword ptr [esp + 0xf0]
            //   4881faffffff3f       | inc                 ebp
            //   7768                 | mov                 esp, ecx
            //   4883ec38             | push                ebp

        $sequence_6 = { c6431770 488d15d8461100 480f44fa 4d85e4 b8011a0000 48896b08 488d15d040fbff }
            // n = 7, score = 100
            //   c6431770             | inc                 ecx
            //   488d15d8461100       | or                  edx, 0x100000
            //   480f44fa             | inc                 esp
            //   4d85e4               | add                 eax, eax
            //   b8011a0000           | dec                 eax
            //   48896b08             | mov                 eax, dword ptr [esp + 0x68]
            //   488d15d040fbff       | movups              xmmword ptr [ebx + 0x78], xmm6

        $sequence_7 = { e8???????? 4d85ff 7475 440fb74760 410fbf4e36 4139c8 7c66 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4d85ff               | dec                 esp
            //   7475                 | arpl                cx, bp
            //   440fb74760           | mov                 dword ptr [ebx + 0x90], ecx
            //   410fbf4e36           | dec                 eax
            //   4139c8               | mov                 ebx, dword ptr [esp + 0x128]
            //   7c66                 | dec                 esp

        $sequence_8 = { f77134 8d5001 4439fa 0f84b0010000 4531c9 4c8d442448 4489fa }
            // n = 7, score = 100
            //   f77134               | lea                 eax, [ecx + 0x6400]
            //   8d5001               | dec                 eax
            //   4439fa               | lea                 eax, [ecx + 0x6400]
            //   0f84b0010000         | dec                 eax
            //   4531c9               | mov                 dword ptr [esp + 0x40], eax
            //   4c8d442448           | dec                 eax
            //   4489fa               | lea                 eax, [ecx + 0x6404]

        $sequence_9 = { e8???????? 4829c4 488b4548 4885c9 742d 4989ca 4883796800 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4829c4               | mov                 ebx, dword ptr [ebx + 0x40]
            //   488b4548             | inc                 esp
            //   4885c9               | mov                 dword ptr [eax + edx*8 + 8], ecx
            //   742d                 | mov                 dword ptr [eax + edx*8 + 0xc], 0
            //   4989ca               | dec                 eax
            //   4883796800           | mov                 dword ptr [eax + edx*8 + 0x10], 0

    condition:
        7 of them and filesize < 27009024
}