rule win_sappycache_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sappycache."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sappycache"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 4c8bc3 33d2 488bc8 488907 488be8 e8???????? }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   4c8bc3               | mov                 edx, 0x20000
            //   33d2                 | mov                 ecx, 0x40
            //   488bc8               | dec                 esp
            //   488907               | mov                 esi, dword ptr [ebp + 0x30]
            //   488be8               | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { 0f84a0000000 817c242000140000 0f8592000000 488d05b8600100 b928000000 }
            // n = 5, score = 200
            //   0f84a0000000         | mov                 dword ptr [esp + 0x20], 3
            //   817c242000140000     | inc                 ebp
            //   0f8592000000         | lea                 eax, [ecx + 3]
            //   488d05b8600100       | dec                 eax
            //   b928000000           | mov                 esi, eax

        $sequence_2 = { 4863c9 488d1556fa0000 488bc1 83e13f 48c1f806 }
            // n = 5, score = 200
            //   4863c9               | jl                  0xc9
            //   488d1556fa0000       | dec                 esp
            //   488bc1               | lea                 ecx, [0x130bc]
            //   83e13f               | dec                 ebp
            //   48c1f806             | test                edx, edx

        $sequence_3 = { 4c8d442440 8bca 488d542448 48c1e109 4903cc e8???????? 488b5c2448 }
            // n = 7, score = 200
            //   4c8d442440           | xor                 ecx, esp
            //   8bca                 | dec                 eax
            //   488d542448           | add                 esp, 0x6348
            //   48c1e109             | inc                 ecx
            //   4903cc               | pop                 ebp
            //   e8????????           |                     
            //   488b5c2448           | pop                 esi

        $sequence_4 = { 488bfb 48895c2420 8b05???????? 3bf0 7c3b 4c8d3db7fa0000 }
            // n = 6, score = 200
            //   488bfb               | lea                 eax, [0x9833]
            //   48895c2420           | dec                 eax
            //   8b05????????         |                     
            //   3bf0                 | mov                 ebx, ecx
            //   7c3b                 | dec                 eax
            //   4c8d3db7fa0000       | mov                 dword ptr [ecx], eax

        $sequence_5 = { 4889442478 488bd8 4885c0 0f840d060000 4889bc2488630000 }
            // n = 5, score = 200
            //   4889442478           | dec                 esp
            //   488bd8               | mov                 edi, dword ptr [esp + 0x6330]
            //   4885c0               | inc                 ecx
            //   0f840d060000         | movzx               eax, al
            //   4889bc2488630000     | inc                 edx

        $sequence_6 = { 488bcf ff15???????? b801000000 488b6c2440 488b742448 488b7c2450 488b4c2428 }
            // n = 7, score = 200
            //   488bcf               | mov                 ecx, dword ptr [eax + 0x88]
            //   ff15????????         |                     
            //   b801000000           | dec                 eax
            //   488b6c2440           | lea                 eax, [0xf15d]
            //   488b742448           | dec                 eax
            //   488b7c2450           | cmp                 ecx, eax
            //   488b4c2428           | je                  0x2a4

        $sequence_7 = { ff15???????? 488d4540 498bd7 48ffc2 44382c10 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   488d4540             | lea                 ecx, [esp + 0x284]
            //   498bd7               | inc                 ecx
            //   48ffc2               | mov                 eax, 0x434
            //   44382c10             | dec                 eax

        $sequence_8 = { 488d15bdcbffff 488d0c10 813950450000 755f b80b020000 66394118 7554 }
            // n = 7, score = 200
            //   488d15bdcbffff       | lea                 edi, [0xfab7]
            //   488d0c10             | dec                 ecx
            //   813950450000         | cmp                 dword ptr [edi + edi*8], ebx
            //   755f                 | dec                 eax
            //   b80b020000           | mov                 edi, ebx
            //   66394118             | dec                 esp
            //   7554                 | lea                 esi, [0xf9ea]

        $sequence_9 = { 4883ec68 488b05???????? 4833c4 4889442450 33ff 33db }
            // n = 6, score = 200
            //   4883ec68             | lea                 edx, [ebp - 8]
            //   488b05????????       |                     
            //   4833c4               | dec                 edx
            //   4889442450           | mov                 ecx, dword ptr [ecx + esi + 0x28]
            //   33ff                 | inc                 edx
            //   33db                 | cmp                 dword ptr [ecx], 0x4550

    condition:
        7 of them and filesize < 262144
}