rule win_sasfis_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sasfis."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sasfis"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 241c 2c05 006188 c526 3503007ca3 ef 2b30 }
            // n = 7, score = 100
            //   241c                 | and                 al, 0x1c
            //   2c05                 | sub                 al, 5
            //   006188               | add                 byte ptr [ecx - 0x78], ah
            //   c526                 | lds                 esp, ptr [esi]
            //   3503007ca3           | xor                 eax, 0xa37c0003
            //   ef                   | out                 dx, eax
            //   2b30                 | sub                 esi, dword ptr [eax]

        $sequence_1 = { 0bb2ea7632d3 728b 896b90 35d0797819 d581 }
            // n = 5, score = 100
            //   0bb2ea7632d3         | or                  esi, dword ptr [edx - 0x2ccd8916]
            //   728b                 | jb                  0xffffff8d
            //   896b90               | mov                 dword ptr [ebx - 0x70], ebp
            //   35d0797819           | xor                 eax, 0x197879d0
            //   d581                 | aad                 0x81

        $sequence_2 = { 880c24 8d642450 e9???????? 60 }
            // n = 4, score = 100
            //   880c24               | mov                 byte ptr [esp], cl
            //   8d642450             | lea                 esp, [esp + 0x50]
            //   e9????????           |                     
            //   60                   | pushal              

        $sequence_3 = { 8f44241c f9 66ffc7 0fbdfa 80fe07 87742418 660fbafe06 }
            // n = 7, score = 100
            //   8f44241c             | pop                 dword ptr [esp + 0x1c]
            //   f9                   | stc                 
            //   66ffc7               | inc                 di
            //   0fbdfa               | bsr                 edi, edx
            //   80fe07               | cmp                 dh, 7
            //   87742418             | xchg                dword ptr [esp + 0x18], esi
            //   660fbafe06           | btc                 si, 6

        $sequence_4 = { 036e20 43 7465 47 }
            // n = 4, score = 100
            //   036e20               | add                 ebp, dword ptr [esi + 0x20]
            //   43                   | inc                 ebx
            //   7465                 | je                  0x67
            //   47                   | inc                 edi

        $sequence_5 = { 2030 51 090a 4d 1321 }
            // n = 5, score = 100
            //   2030                 | and                 byte ptr [eax], dh
            //   51                   | push                ecx
            //   090a                 | or                  dword ptr [edx], ecx
            //   4d                   | dec                 ebp
            //   1321                 | adc                 esp, dword ptr [ecx]

        $sequence_6 = { 66893c24 89442434 9c 660fbef8 9c 89542438 68d58c61ca }
            // n = 7, score = 100
            //   66893c24             | mov                 word ptr [esp], di
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   9c                   | pushfd              
            //   660fbef8             | movsx               di, al
            //   9c                   | pushfd              
            //   89542438             | mov                 dword ptr [esp + 0x38], edx
            //   68d58c61ca           | push                0xca618cd5

        $sequence_7 = { 660fbec2 660fb6c0 8b4500 e8???????? 661584f0 fec0 27 }
            // n = 7, score = 100
            //   660fbec2             | movsx               ax, dl
            //   660fb6c0             | movzx               ax, al
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   e8????????           |                     
            //   661584f0             | adc                 ax, 0xf084
            //   fec0                 | inc                 al
            //   27                   | daa                 

        $sequence_8 = { 7aae 2931 55 3cf4 b729 0300 47 }
            // n = 7, score = 100
            //   7aae                 | jp                  0xffffffb0
            //   2931                 | sub                 dword ptr [ecx], esi
            //   55                   | push                ebp
            //   3cf4                 | cmp                 al, 0xf4
            //   b729                 | mov                 bh, 0x29
            //   0300                 | add                 eax, dword ptr [eax]
            //   47                   | inc                 edi

        $sequence_9 = { 9c 8f442440 8d3cfd9c379c8f 66ffcf }
            // n = 4, score = 100
            //   9c                   | pushfd              
            //   8f442440             | pop                 dword ptr [esp + 0x40]
            //   8d3cfd9c379c8f       | lea                 edi, [edi*8 - 0x7063c864]
            //   66ffcf               | dec                 di

    condition:
        7 of them and filesize < 8060928
}