rule win_satan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.satan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.satan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b02 c1f806 8b4d0c 8b11 83e23f 6bca30 8b148540e04700 }
            // n = 7, score = 100
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   c1f806               | sar                 eax, 6
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   83e23f               | and                 edx, 0x3f
            //   6bca30               | imul                ecx, edx, 0x30
            //   8b148540e04700       | mov                 edx, dword ptr [eax*4 + 0x47e040]

        $sequence_1 = { 8d4db8 c745fcffffffff e8???????? 8d45b8 c745fc10000000 50 8d45e4 }
            // n = 7, score = 100
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   c745fc10000000       | mov                 dword ptr [ebp - 4], 0x10
            //   50                   | push                eax
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_2 = { 8945cc c645d300 c745c8ffffffff 83cbff 895dc4 c745d800000000 c745dc00000000 }
            // n = 7, score = 100
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   c645d300             | mov                 byte ptr [ebp - 0x2d], 0
            //   c745c8ffffffff       | mov                 dword ptr [ebp - 0x38], 0xffffffff
            //   83cbff               | or                  ebx, 0xffffffff
            //   895dc4               | mov                 dword ptr [ebp - 0x3c], ebx
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0

        $sequence_3 = { 3305???????? b904000000 6bd124 8982d0d14700 68???????? 8b45fc 50 }
            // n = 7, score = 100
            //   3305????????         |                     
            //   b904000000           | mov                 ecx, 4
            //   6bd124               | imul                edx, ecx, 0x24
            //   8982d0d14700         | mov                 dword ptr [edx + 0x47d1d0], eax
            //   68????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax

        $sequence_4 = { 660f123d???????? 25ff010000 83c001 25fe030000 f20f592c85c01a4700 f20f591485c01a4700 660f5834c5d0224700 }
            // n = 7, score = 100
            //   660f123d????????     |                     
            //   25ff010000           | and                 eax, 0x1ff
            //   83c001               | add                 eax, 1
            //   25fe030000           | and                 eax, 0x3fe
            //   f20f592c85c01a4700     | mulsd    xmm5, qword ptr [eax*4 + 0x471ac0]
            //   f20f591485c01a4700     | mulsd    xmm2, qword ptr [eax*4 + 0x471ac0]
            //   660f5834c5d0224700     | addpd    xmm6, xmmword ptr [eax*8 + 0x4722d0]

        $sequence_5 = { 7511 3d00200000 740a be06000000 33c9 8975c0 894dc8 }
            // n = 7, score = 100
            //   7511                 | jne                 0x13
            //   3d00200000           | cmp                 eax, 0x2000
            //   740a                 | je                  0xc
            //   be06000000           | mov                 esi, 6
            //   33c9                 | xor                 ecx, ecx
            //   8975c0               | mov                 dword ptr [ebp - 0x40], esi
            //   894dc8               | mov                 dword ptr [ebp - 0x38], ecx

        $sequence_6 = { f20f5cc3 03c0 03c0 03c0 03c0 660f289800334700 660f2835???????? }
            // n = 7, score = 100
            //   f20f5cc3             | subsd               xmm0, xmm3
            //   03c0                 | add                 eax, eax
            //   03c0                 | add                 eax, eax
            //   03c0                 | add                 eax, eax
            //   03c0                 | add                 eax, eax
            //   660f289800334700     | movapd              xmm3, xmmword ptr [eax + 0x473300]
            //   660f2835????????     |                     

        $sequence_7 = { c745fc00000000 33c9 8b751c ba02000000 46 8bc6 f7e2 }
            // n = 7, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   33c9                 | xor                 ecx, ecx
            //   8b751c               | mov                 esi, dword ptr [ebp + 0x1c]
            //   ba02000000           | mov                 edx, 2
            //   46                   | inc                 esi
            //   8bc6                 | mov                 eax, esi
            //   f7e2                 | mul                 edx

        $sequence_8 = { 8bff 55 8bec 83ec10 8b4508 8d0c8598e24700 51 }
            // n = 7, score = 100
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d0c8598e24700       | lea                 ecx, [eax*4 + 0x47e298]
            //   51                   | push                ecx

        $sequence_9 = { e8???????? 8d45b8 c745fc10000000 50 8d45e4 b9???????? 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   c745fc10000000       | mov                 dword ptr [ebp - 4], 0x10
            //   50                   | push                eax
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   b9????????           |                     
            //   50                   | push                eax

    condition:
        7 of them and filesize < 1163264
}