rule win_sathurbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sathurbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sathurbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f6c101 0f94c0 813d????????0a000000 0f9cc1 08c1 b84b7e8b0c 0f45c3 }
            // n = 7, score = 100
            //   f6c101               | test                cl, 1
            //   0f94c0               | sete                al
            //   813d????????0a000000     |     
            //   0f9cc1               | setl                cl
            //   08c1                 | or                  cl, al
            //   b84b7e8b0c           | mov                 eax, 0xc8b7e4b
            //   0f45c3               | cmovne              eax, ebx

        $sequence_1 = { f6c101 0f94c0 813d????????0a000000 0f9cc1 08c1 bfcc456d5f b8dd72d480 }
            // n = 7, score = 100
            //   f6c101               | test                cl, 1
            //   0f94c0               | sete                al
            //   813d????????0a000000     |     
            //   0f9cc1               | setl                cl
            //   08c1                 | or                  cl, al
            //   bfcc456d5f           | mov                 edi, 0x5f6d45cc
            //   b8dd72d480           | mov                 eax, 0x80d472dd

        $sequence_2 = { e9???????? 81fe44b0cddc 7f16 81fe7313fbac 0f850dffffff be80c3aea4 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   81fe44b0cddc         | cmp                 esi, 0xdccdb044
            //   7f16                 | jg                  0x18
            //   81fe7313fbac         | cmp                 esi, 0xacfb1373
            //   0f850dffffff         | jne                 0xffffff13
            //   be80c3aea4           | mov                 esi, 0xa4aec380
            //   e9????????           |                     

        $sequence_3 = { f6c101 0f94c0 813d????????0a000000 0f9cc1 08c1 b8d1e835c1 b93dd672c9 }
            // n = 7, score = 100
            //   f6c101               | test                cl, 1
            //   0f94c0               | sete                al
            //   813d????????0a000000     |     
            //   0f9cc1               | setl                cl
            //   08c1                 | or                  cl, al
            //   b8d1e835c1           | mov                 eax, 0xc135e8d1
            //   b93dd672c9           | mov                 ecx, 0xc972d63d

        $sequence_4 = { ebd8 81fa06cfb547 7f27 81fab0570bce 7f30 81fabe1990c9 75c2 }
            // n = 7, score = 100
            //   ebd8                 | jmp                 0xffffffda
            //   81fa06cfb547         | cmp                 edx, 0x47b5cf06
            //   7f27                 | jg                  0x29
            //   81fab0570bce         | cmp                 edx, 0xce0b57b0
            //   7f30                 | jg                  0x32
            //   81fabe1990c9         | cmp                 edx, 0xc99019be
            //   75c2                 | jne                 0xffffffc4

        $sequence_5 = { ebfe 55 89e5 53 56 83ec02 a1???????? }
            // n = 7, score = 100
            //   ebfe                 | jmp                 0
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   56                   | push                esi
            //   83ec02               | sub                 esp, 2
            //   a1????????           |                     

        $sequence_6 = { eb3e 897c2408 8b450c 89442404 893424 e8???????? 8945f0 }
            // n = 7, score = 100
            //   eb3e                 | jmp                 0x40
            //   897c2408             | mov                 dword ptr [esp + 8], edi
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_7 = { f6c101 0f94c0 813d????????0a000000 0f9cc1 08c1 b8aebf6a24 0f45c3 }
            // n = 7, score = 100
            //   f6c101               | test                cl, 1
            //   0f94c0               | sete                al
            //   813d????????0a000000     |     
            //   0f9cc1               | setl                cl
            //   08c1                 | or                  cl, al
            //   b8aebf6a24           | mov                 eax, 0x246abfae
            //   0f45c3               | cmovne              eax, ebx

        $sequence_8 = { e9???????? c744240400000000 c7042401000000 89f1 e8???????? 83ec08 8b442454 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   c7042401000000       | mov                 dword ptr [esp], 1
            //   89f1                 | mov                 ecx, esi
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]

        $sequence_9 = { f6c101 0f94c0 813d????????0a000000 0f9cc1 08c1 b86e66c620 b9a93409fe }
            // n = 7, score = 100
            //   f6c101               | test                cl, 1
            //   0f94c0               | sete                al
            //   813d????????0a000000     |     
            //   0f9cc1               | setl                cl
            //   08c1                 | or                  cl, al
            //   b86e66c620           | mov                 eax, 0x20c6666e
            //   b9a93409fe           | mov                 ecx, 0xfe0934a9

    condition:
        7 of them and filesize < 2727936
}