rule win_scanpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scanpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scanpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 64a300000000 8b4508 33d2 c745e80f000000 8955e4 }
            // n = 5, score = 200
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   33d2                 | xor                 edx, edx
            //   c745e80f000000       | mov                 dword ptr [ebp - 0x18], 0xf
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx

        $sequence_1 = { 3ad3 75f9 2bc1 8bd0 }
            // n = 4, score = 200
            //   3ad3                 | cmp                 dl, bl
            //   75f9                 | jne                 0xfffffffb
            //   2bc1                 | sub                 eax, ecx
            //   8bd0                 | mov                 edx, eax

        $sequence_2 = { e8???????? 83c404 8b0d???????? 8939 8b15???????? 893a }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b0d????????         |                     
            //   8939                 | mov                 dword ptr [ecx], edi
            //   8b15????????         |                     
            //   893a                 | mov                 dword ptr [edx], edi

        $sequence_3 = { 8d85e8feffff 50 51 68???????? 68???????? e8???????? 83c40c }
            // n = 7, score = 200
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_4 = { 53 52 ffd0 3bc3 7508 3bd7 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   52                   | push                edx
            //   ffd0                 | call                eax
            //   3bc3                 | cmp                 eax, ebx
            //   7508                 | jne                 0xa
            //   3bd7                 | cmp                 edx, edi

        $sequence_5 = { e9???????? 8db5acfeffff e9???????? 8b542408 8d420c 8b8a8cfeffff 33c8 }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8db5acfeffff         | lea                 esi, [ebp - 0x154]
            //   e9????????           |                     
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d420c               | lea                 eax, [edx + 0xc]
            //   8b8a8cfeffff         | mov                 ecx, dword ptr [edx - 0x174]
            //   33c8                 | xor                 ecx, eax

        $sequence_6 = { e8???????? 03c8 8b4608 2bc2 3bc8 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   03c8                 | add                 ecx, eax
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   2bc2                 | sub                 eax, edx
            //   3bc8                 | cmp                 ecx, eax

        $sequence_7 = { 50 8d45f4 64a300000000 8b4508 8918 8b0b }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8918                 | mov                 dword ptr [eax], ebx
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_8 = { 3bfb 0f82b9fdffff 837de810 720c 8b4dd4 }
            // n = 5, score = 200
            //   3bfb                 | cmp                 edi, ebx
            //   0f82b9fdffff         | jb                  0xfffffdbf
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   720c                 | jb                  0xe
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]

        $sequence_9 = { 6aff 68???????? 53 ff15???????? 85c0 0f95c3 837dcc10 }
            // n = 7, score = 200
            //   6aff                 | push                -1
            //   68????????           |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f95c3               | setne               bl
            //   837dcc10             | cmp                 dword ptr [ebp - 0x34], 0x10

    condition:
        7 of them and filesize < 229376
}