rule win_scarabey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scarabey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scarabey"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a01 ff5004 899e58030000 e9???????? c78778010000acab5700 }
            // n = 5, score = 100
            //   6a01                 | push                1
            //   ff5004               | call                dword ptr [eax + 4]
            //   899e58030000         | mov                 dword ptr [esi + 0x358], ebx
            //   e9????????           |                     
            //   c78778010000acab5700     | mov    dword ptr [edi + 0x178], 0x57abac

        $sequence_1 = { 51 50 8d45c0 50 ffd7 897598 c74594fc2f5300 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   897598               | mov                 dword ptr [ebp - 0x68], esi
            //   c74594fc2f5300       | mov                 dword ptr [ebp - 0x6c], 0x532ffc

        $sequence_2 = { 51 ff15???????? 8d8dc0d6ffff e8???????? 8b95c0d6ffff 52 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d8dc0d6ffff         | lea                 ecx, [ebp - 0x2940]
            //   e8????????           |                     
            //   8b95c0d6ffff         | mov                 edx, dword ptr [ebp - 0x2940]
            //   52                   | push                edx

        $sequence_3 = { 8b442408 8b4c2404 6a00 6a00 6a00 6a00 50 }
            // n = 7, score = 100
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_4 = { ff15???????? 6a01 8d8d14d1ffff 51 ff15???????? 6a00 6a00 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8d8d14d1ffff         | lea                 ecx, [ebp - 0x2eec]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 894608 89460c c706???????? c74604???????? c74610541e5300 e8???????? 8bc6 }
            // n = 7, score = 100
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   c706????????         |                     
            //   c74604????????       |                     
            //   c74610541e5300       | mov                 dword ptr [esi + 0x10], 0x531e54
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi

        $sequence_6 = { e9???????? 837dec00 0f851a010000 6683f80c 0f8510010000 6a0a }
            // n = 6, score = 100
            //   e9????????           |                     
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   0f851a010000         | jne                 0x120
            //   6683f80c             | cmp                 ax, 0xc
            //   0f8510010000         | jne                 0x116
            //   6a0a                 | push                0xa

        $sequence_7 = { 8bf0 83f907 7771 ff248d690c4700 4e eb26 }
            // n = 6, score = 100
            //   8bf0                 | mov                 esi, eax
            //   83f907               | cmp                 ecx, 7
            //   7771                 | ja                  0x73
            //   ff248d690c4700       | jmp                 dword ptr [ecx*4 + 0x470c69]
            //   4e                   | dec                 esi
            //   eb26                 | jmp                 0x28

        $sequence_8 = { c745bc06000000 897dd0 c745c404885300 c745cc64000000 ff9060010000 }
            // n = 5, score = 100
            //   c745bc06000000       | mov                 dword ptr [ebp - 0x44], 6
            //   897dd0               | mov                 dword ptr [ebp - 0x30], edi
            //   c745c404885300       | mov                 dword ptr [ebp - 0x3c], 0x538804
            //   c745cc64000000       | mov                 dword ptr [ebp - 0x34], 0x64
            //   ff9060010000         | call                dword ptr [eax + 0x160]

        $sequence_9 = { c745cc18405300 e8???????? 33c0 40 e8???????? c20400 6a08 }
            // n = 7, score = 100
            //   c745cc18405300       | mov                 dword ptr [ebp - 0x34], 0x534018
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   e8????????           |                     
            //   c20400               | ret                 4
            //   6a08                 | push                8

    condition:
        7 of them and filesize < 3580928
}