rule win_scieron_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scieron."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scieron"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 85ff 7411 833d????????00 }
            // n = 4, score = 100
            //   ffd0                 | call                eax
            //   85ff                 | test                edi, edi
            //   7411                 | je                  0x13
            //   833d????????00       |                     

        $sequence_1 = { 8b442424 33ff 217c241c 0144241c ff442410 6a10 58 }
            // n = 7, score = 100
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   33ff                 | xor                 edi, edi
            //   217c241c             | and                 dword ptr [esp + 0x1c], edi
            //   0144241c             | add                 dword ptr [esp + 0x1c], eax
            //   ff442410             | inc                 dword ptr [esp + 0x10]
            //   6a10                 | push                0x10
            //   58                   | pop                 eax

        $sequence_2 = { 57 eb6b 8b7c2410 3bfd }
            // n = 4, score = 100
            //   57                   | push                edi
            //   eb6b                 | jmp                 0x6d
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   3bfd                 | cmp                 edi, ebp

        $sequence_3 = { ffb614400010 83c718 ffb618400010 8d443c30 50 }
            // n = 5, score = 100
            //   ffb614400010         | push                dword ptr [esi + 0x10004014]
            //   83c718               | add                 edi, 0x18
            //   ffb618400010         | push                dword ptr [esi + 0x10004018]
            //   8d443c30             | lea                 eax, [esp + edi + 0x30]
            //   50                   | push                eax

        $sequence_4 = { c9 c3 55 8bec 51 e8???????? e8???????? }
            // n = 7, score = 100
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_5 = { 7542 50 50 0fb78604020000 }
            // n = 4, score = 100
            //   7542                 | jne                 0x44
            //   50                   | push                eax
            //   50                   | push                eax
            //   0fb78604020000       | movzx               eax, word ptr [esi + 0x204]

        $sequence_6 = { ffd7 ffd0 6a04 8d442414 }
            // n = 4, score = 100
            //   ffd7                 | call                edi
            //   ffd0                 | call                eax
            //   6a04                 | push                4
            //   8d442414             | lea                 eax, [esp + 0x14]

        $sequence_7 = { e9???????? 81ec8c020000 53 8b1d???????? 55 33c0 57 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   81ec8c020000         | sub                 esp, 0x28c
            //   53                   | push                ebx
            //   8b1d????????         |                     
            //   55                   | push                ebp
            //   33c0                 | xor                 eax, eax
            //   57                   | push                edi

        $sequence_8 = { 8d85d8fdffff 50 ffd6 85c0 7409 }
            // n = 5, score = 100
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb

        $sequence_9 = { 53 6a40 ffd7 85c0 7414 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   6a40                 | push                0x40
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16

    condition:
        7 of them and filesize < 100352
}