rule win_scout_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scout."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scout"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 817c243031313131 7445 690d????????60ea0000 ff15???????? 8b0d???????? b867666666 ffc1 }
            // n = 7, score = 100
            //   817c243031313131     | test                eax, eax
            //   7445                 | je                  0x17c
            //   690d????????60ea0000     |     
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   b867666666           | dec                 eax
            //   ffc1                 | sub                 esp, 0x28

        $sequence_1 = { 8d58b0 498bce 448bc3 488d154cac0000 e8???????? 85c0 }
            // n = 6, score = 100
            //   8d58b0               | and                 ecx, 0x3f
            //   498bce               | dec                 eax
            //   448bc3               | sar                 eax, 6
            //   488d154cac0000       | inc                 ebp
            //   e8????????           |                     
            //   85c0                 | xor                 edi, edi

        $sequence_2 = { 7706 ff15???????? 488364243000 488d0d849f0000 8364242800 41b803000000 4533c9 }
            // n = 7, score = 100
            //   7706                 | mov                 ebx, ecx
            //   ff15????????         |                     
            //   488364243000         | dec                 eax
            //   488d0d849f0000       | cmp                 ecx, eax
            //   8364242800           | je                  0x12e4
            //   41b803000000         | mov                 eax, dword ptr [ecx + 0x15c]
            //   4533c9               | test                eax, eax

        $sequence_3 = { 83c8ff eb0b 4803f6 418b84f728950100 }
            // n = 4, score = 100
            //   83c8ff               | lea                 edi, [0x15fcd]
            //   eb0b                 | dec                 eax
            //   4803f6               | mov                 ecx, dword ptr [ebx + edi]
            //   418b84f728950100     | dec                 eax

        $sequence_4 = { 0f84aa000000 83f81a 0f85eb020000 33ff 488d4c2430 48897c2430 }
            // n = 6, score = 100
            //   0f84aa000000         | lea                 edx, [0xc025]
            //   83f81a               | dec                 eax
            //   0f85eb020000         | test                eax, eax
            //   33ff                 | je                  0x1563
            //   488d4c2430           | dec                 eax
            //   48897c2430           | mov                 edx, ebx

        $sequence_5 = { 488b8d80140000 ff15???????? 488d537c 41b888140000 }
            // n = 4, score = 100
            //   488b8d80140000       | add                 edi, ecx
            //   ff15????????         |                     
            //   488d537c             | dec                 eax
            //   41b888140000         | sub                 eax, 1

        $sequence_6 = { 4885c9 750b 488d0d29f10000 48894b48 4963d0 e8???????? }
            // n = 6, score = 100
            //   4885c9               | cmp                 ecx, dword ptr [edx]
            //   750b                 | je                  0x979
            //   488d0d29f10000       | dec                 esp
            //   48894b48             | lea                 ecx, [0xffff04ea]
            //   4963d0               | dec                 esp
            //   e8????????           |                     

        $sequence_7 = { 488d0d36fbfeff 83e03f 458be9 4d03e8 4c8945df 4c8be6 }
            // n = 6, score = 100
            //   488d0d36fbfeff       | mov                 ecx, dword ptr [eax + 0x205b0]
            //   83e03f               | mov                 ecx, dword ptr [esp + 0x48]
            //   458be9               | dec                 eax
            //   4d03e8               | lea                 edx, [0xffff14d2]
            //   4c8945df             | sub                 ecx, dword ptr [esp + 0x4c]
            //   4c8be6               | inc                 ecx

        $sequence_8 = { 488d0dd4f90000 4183e23f 4d03f0 4d8bf8 }
            // n = 4, score = 100
            //   488d0dd4f90000       | mov                 dword ptr [esp + 0x20], eax
            //   4183e23f             | dec                 eax
            //   4d03f0               | mov                 edi, eax
            //   4d8bf8               | dec                 eax

        $sequence_9 = { 0f84aa000000 83f81a 0f85eb020000 33ff 488d4c2430 48897c2430 e8???????? }
            // n = 7, score = 100
            //   0f84aa000000         | lea                 edi, [0x135e0]
            //   83f81a               | dec                 eax
            //   0f85eb020000         | sub                 edi, esi
            //   33ff                 | mov                 al, byte ptr [edi + ebx]
            //   488d4c2430           | mov                 byte ptr [ebx], al
            //   48897c2430           | dec                 eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 315392
}