rule win_scranos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scranos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scranos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8d4dd0 e9???????? 8d8d64ffffff e9???????? b8???????? e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e9????????           |                     
            //   8d8d64ffffff         | lea                 ecx, [ebp - 0x9c]
            //   e9????????           |                     
            //   b8????????           |                     
            //   e9????????           |                     

        $sequence_1 = { c68424450e00002d 8db424460e0000 f6c102 7406 c6062b 83c601 f6c101 }
            // n = 7, score = 100
            //   c68424450e00002d     | mov                 byte ptr [esp + 0xe45], 0x2d
            //   8db424460e0000       | lea                 esi, [esp + 0xe46]
            //   f6c102               | test                cl, 2
            //   7406                 | je                  8
            //   c6062b               | mov                 byte ptr [esi], 0x2b
            //   83c601               | add                 esi, 1
            //   f6c101               | test                cl, 1

        $sequence_2 = { c745a800000000 837d9c00 7508 8b45a0 8b08 894d9c 8b55f4 }
            // n = 7, score = 100
            //   c745a800000000       | mov                 dword ptr [ebp - 0x58], 0
            //   837d9c00             | cmp                 dword ptr [ebp - 0x64], 0
            //   7508                 | jne                 0xa
            //   8b45a0               | mov                 eax, dword ptr [ebp - 0x60]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   894d9c               | mov                 dword ptr [ebp - 0x64], ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_3 = { e8???????? 83c404 85c0 0f8587050000 39442424 0f8570050000 8b8d940c0000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f8587050000         | jne                 0x58d
            //   39442424             | cmp                 dword ptr [esp + 0x24], eax
            //   0f8570050000         | jne                 0x576
            //   8b8d940c0000         | mov                 ecx, dword ptr [ebp + 0xc94]

        $sequence_4 = { c745b07c441010 e8???????? cc 6a44 b8???????? e8???????? 68???????? }
            // n = 7, score = 100
            //   c745b07c441010       | mov                 dword ptr [ebp - 0x50], 0x1010447c
            //   e8????????           |                     
            //   cc                   | int3                
            //   6a44                 | push                0x44
            //   b8????????           |                     
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_5 = { 8d6803 e8???????? 83c40c 85c0 0f85c4000000 6a07 56 }
            // n = 7, score = 100
            //   8d6803               | lea                 ebp, [eax + 3]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f85c4000000         | jne                 0xca
            //   6a07                 | push                7
            //   56                   | push                esi

        $sequence_6 = { 8b5518 8991e0010000 c745f800000000 eb09 8b45f8 83c001 8945f8 }
            // n = 7, score = 100
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]
            //   8991e0010000         | mov                 dword ptr [ecx + 0x1e0], edx
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   eb09                 | jmp                 0xb
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83c001               | add                 eax, 1
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_7 = { c6405400 0fb64dff 85c9 7514 8b55e4 8b45ec 3b424c }
            // n = 7, score = 100
            //   c6405400             | mov                 byte ptr [eax + 0x54], 0
            //   0fb64dff             | movzx               ecx, byte ptr [ebp - 1]
            //   85c9                 | test                ecx, ecx
            //   7514                 | jne                 0x16
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   3b424c               | cmp                 eax, dword ptr [edx + 0x4c]

        $sequence_8 = { 90 8d442410 50 6a00 55 56 e8???????? }
            // n = 7, score = 100
            //   90                   | nop                 
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   55                   | push                ebp
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_9 = { c7414802000000 8b55e8 52 e8???????? 83c404 83c001 8945b0 }
            // n = 7, score = 100
            //   c7414802000000       | mov                 dword ptr [ecx + 0x48], 2
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83c001               | add                 eax, 1
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax

    condition:
        7 of them and filesize < 2859008
}