rule win_screencap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.screencap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.screencap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750d 6800000080 6a06 ff15???????? }
            // n = 4, score = 100
            //   750d                 | jmp                 0xe1e
            //   6800000080           | dec                 eax
            //   6a06                 | lea                 edx, [0xd0cd]
            //   ff15????????         |                     

        $sequence_1 = { 488d0d1aba0000 e8???????? cc 488b4118 }
            // n = 4, score = 100
            //   488d0d1aba0000       | dec                 ecx
            //   e8????????           |                     
            //   cc                   | cmovae              edi, eax
            //   488b4118             | dec                 eax

        $sequence_2 = { 488d1557c90000 eb2b 488d153ec90000 eb22 }
            // n = 4, score = 100
            //   488d1557c90000       | mov                 dword ptr [esp + 0x38], eax
            //   eb2b                 | dec                 eax
            //   488d153ec90000       | mov                 dword ptr [esp + 0x30], ebx
            //   eb22                 | xor                 ecx, ecx

        $sequence_3 = { 488d156cd90000 488d8d90020000 4d8bc7 e8???????? 488d9580010000 488d4c2470 4533c9 }
            // n = 7, score = 100
            //   488d156cd90000       | lea                 eax, [ebp + 0x3054]
            //   488d8d90020000       | push                0x30
            //   4d8bc7               | mov                 dword ptr [ebp - 0x4c], eax
            //   e8????????           |                     
            //   488d9580010000       | lea                 eax, [ebp - 0x88]
            //   488d4c2470           | mov                 dword ptr [ebp - 0x4c], eax
            //   4533c9               | lea                 eax, [ebp - 0x88]

        $sequence_4 = { 48895c2408 57 4881ecb0000000 488d054cffffff 33db ba007f0000 33c9 }
            // n = 7, score = 100
            //   48895c2408           | lea                 ebx, [0x747f]
            //   57                   | dec                 eax
            //   4881ecb0000000       | lea                 edx, [ebp + 0x47]
            //   488d054cffffff       | dec                 eax
            //   33db                 | lea                 ecx, [ebp - 0x11]
            //   ba007f0000           | dec                 esp
            //   33c9                 | mov                 dword ptr [ebp + 0x47], ebx

        $sequence_5 = { 4c8d442460 33d2 33c9 41d1e9 896c2428 4889742420 }
            // n = 6, score = 100
            //   4c8d442460           | or                  ecx, 0xffffffff
            //   33d2                 | dec                 eax
            //   33c9                 | mov                 dword ptr [esp + 0x270], ebx
            //   41d1e9               | xor                 eax, eax
            //   896c2428             | dec                 eax
            //   4889742420           | mov                 eax, dword ptr [esp + 0x50]

        $sequence_6 = { eb4e 8d4306 39842420100000 7640 6a04 687c334700 55 }
            // n = 7, score = 100
            //   eb4e                 | mov                 edi, 0x24
            //   8d4306               | dec                 eax
            //   39842420100000       | lea                 ebx, [0x9c18]
            //   7640                 | mov                 esi, edi
            //   6a04                 | dec                 eax
            //   687c334700           | mov                 ebp, dword ptr [ebx]
            //   55                   | dec                 eax

        $sequence_7 = { e9???????? 488d1554ca0000 e9???????? 498bd7 e9???????? 488d1570c60000 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d1554ca0000       | dec                 eax
            //   e9????????           |                     
            //   498bd7               | sub                 edi, eax
            //   e9????????           |                     
            //   488d1570c60000       | dec                 eax
            //   e9????????           |                     

        $sequence_8 = { e9???????? 4c8bfb 4c8be3 488d055eeb0000 49c1fc05 4183e71f 4a8b0ce0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4c8bfb               | and                 dword ptr [ecx + 8], 0
            //   4c8be3               | dec                 eax
            //   488d055eeb0000       | lea                 eax, [0xad52]
            //   49c1fc05             | mov                 byte ptr [ecx + 0x10], 0
            //   4183e71f             | dec                 eax
            //   4a8b0ce0             | mov                 dword ptr [ecx], eax

        $sequence_9 = { 83c40c 8945a4 8975c8 897dcc 8975d0 8975d4 c645d800 }
            // n = 7, score = 100
            //   83c40c               | push                ebx
            //   8945a4               | mov                 ebx, dword ptr [esp + 0x1014]
            //   8975c8               | push                esi
            //   897dcc               | mov                 esi, dword ptr [esp + 0x1014]
            //   8975d0               | adc                 byte ptr [eax], dl
            //   8975d4               | add                 byte ptr [eax], al
            //   c645d800             | movzx               eax, word ptr [esi]

    condition:
        7 of them and filesize < 1391616
}