rule win_seasalt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.seasalt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.seasalt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d842474010000 6804020000 50 51 ffd5 }
            // n = 5, score = 100
            //   8d842474010000       | lea                 eax, [esp + 0x174]
            //   6804020000           | push                0x204
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ffd5                 | call                ebp

        $sequence_1 = { f7d1 2bf9 8d9578fcffff 8bc1 8bf7 8bfa 8d9578fdffff }
            // n = 7, score = 100
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8d9578fcffff         | lea                 edx, [ebp - 0x388]
            //   8bc1                 | mov                 eax, ecx
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx
            //   8d9578fdffff         | lea                 edx, [ebp - 0x288]

        $sequence_2 = { eb26 8d4508 8db67ccb0010 6a00 50 ff36 }
            // n = 6, score = 100
            //   eb26                 | jmp                 0x28
            //   8d4508               | lea                 eax, [ebp + 8]
            //   8db67ccb0010         | lea                 esi, [esi + 0x1000cb7c]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff36                 | push                dword ptr [esi]

        $sequence_3 = { 33c0 53 57 8a1c10 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8a1c10               | mov                 bl, byte ptr [eax + edx]

        $sequence_4 = { 81ec90010000 8d442400 50 6801010000 ff15???????? f7d8 1bc0 }
            // n = 7, score = 100
            //   81ec90010000         | sub                 esp, 0x190
            //   8d442400             | lea                 eax, [esp]
            //   50                   | push                eax
            //   6801010000           | push                0x101
            //   ff15????????         |                     
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax

        $sequence_5 = { 6a00 8d55e8 6a08 52 50 ffd3 8d4de0 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d55e8               | lea                 edx, [ebp - 0x18]
            //   6a08                 | push                8
            //   52                   | push                edx
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_6 = { 8d8c247c010000 6880000000 51 ff15???????? b981000000 }
            // n = 5, score = 100
            //   8d8c247c010000       | lea                 ecx, [esp + 0x17c]
            //   6880000000           | push                0x80
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   b981000000           | mov                 ecx, 0x81

        $sequence_7 = { 83f964 7d08 8a4301 43 3c2f 75eb }
            // n = 6, score = 100
            //   83f964               | cmp                 ecx, 0x64
            //   7d08                 | jge                 0xa
            //   8a4301               | mov                 al, byte ptr [ebx + 1]
            //   43                   | inc                 ebx
            //   3c2f                 | cmp                 al, 0x2f
            //   75eb                 | jne                 0xffffffed

        $sequence_8 = { a1???????? 53 53 68???????? 8d942484000000 6800020000 }
            // n = 6, score = 100
            //   a1????????           |                     
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   68????????           |                     
            //   8d942484000000       | lea                 edx, [esp + 0x84]
            //   6800020000           | push                0x200

        $sequence_9 = { 51 ff15???????? 8d542412 52 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d542412             | lea                 edx, [esp + 0x12]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 139264
}