rule win_sepulcher_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sepulcher."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sepulcher"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6828080000 33ff 8d85ccf7ffff 57 50 }
            // n = 5, score = 100
            //   6828080000           | push                0x828
            //   33ff                 | xor                 edi, edi
            //   8d85ccf7ffff         | lea                 eax, [ebp - 0x834]
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_1 = { 0fb77124 8b11 668b450c 668944b202 }
            // n = 4, score = 100
            //   0fb77124             | movzx               esi, word ptr [ecx + 0x24]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   668b450c             | mov                 ax, word ptr [ebp + 0xc]
            //   668944b202           | mov                 word ptr [edx + esi*4 + 2], ax

        $sequence_2 = { 56 53 e8???????? 85c0 743d 6a00 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   743d                 | je                  0x3f
            //   6a00                 | push                0

        $sequence_3 = { e8???????? 894608 8b857cffffff 6a3c 894620 8d459c 6a00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   8b857cffffff         | mov                 eax, dword ptr [ebp - 0x84]
            //   6a3c                 | push                0x3c
            //   894620               | mov                 dword ptr [esi + 0x20], eax
            //   8d459c               | lea                 eax, [ebp - 0x64]
            //   6a00                 | push                0

        $sequence_4 = { 668984247e6e0000 0f1184241c6e0000 c784242c6e000006000000 c78424306e000009000000 }
            // n = 4, score = 100
            //   668984247e6e0000     | mov                 word ptr [esp + 0x6e7e], ax
            //   0f1184241c6e0000     | movups              xmmword ptr [esp + 0x6e1c], xmm0
            //   c784242c6e000006000000     | mov    dword ptr [esp + 0x6e2c], 6
            //   c78424306e000009000000     | mov    dword ptr [esp + 0x6e30], 9

        $sequence_5 = { 668975dc 668975e2 668975e4 66c745ac756d c645ae62 8855af }
            // n = 6, score = 100
            //   668975dc             | mov                 word ptr [ebp - 0x24], si
            //   668975e2             | mov                 word ptr [ebp - 0x1e], si
            //   668975e4             | mov                 word ptr [ebp - 0x1c], si
            //   66c745ac756d         | mov                 word ptr [ebp - 0x54], 0x6d75
            //   c645ae62             | mov                 byte ptr [ebp - 0x52], 0x62
            //   8855af               | mov                 byte ptr [ebp - 0x51], dl

        $sequence_6 = { 88043e 46 3c3e 752f 83fe05 7235 }
            // n = 6, score = 100
            //   88043e               | mov                 byte ptr [esi + edi], al
            //   46                   | inc                 esi
            //   3c3e                 | cmp                 al, 0x3e
            //   752f                 | jne                 0x31
            //   83fe05               | cmp                 esi, 5
            //   7235                 | jb                  0x37

        $sequence_7 = { 6a00 8d4df8 51 6a01 8d4dff 51 50 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   6a01                 | push                1
            //   8d4dff               | lea                 ecx, [ebp - 1]
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_8 = { 8b048550de0110 f644082801 7406 8b440818 5d c3 e8???????? }
            // n = 7, score = 100
            //   8b048550de0110       | mov                 eax, dword ptr [eax*4 + 0x1001de50]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7406                 | je                  8
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   e8????????           |                     

        $sequence_9 = { e8???????? 59 8d8c24a0250000 e8???????? 68f2030000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d8c24a0250000       | lea                 ecx, [esp + 0x25a0]
            //   e8????????           |                     
            //   68f2030000           | push                0x3f2

    condition:
        7 of them and filesize < 279552
}