rule win_session_manager_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.session_manager."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.session_manager"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bca 4c8d0579970100 83e13f 488bc2 }
            // n = 4, score = 100
            //   488bca               | dec                 eax
            //   4c8d0579970100       | lea                 ecx, [0x21d45]
            //   83e13f               | dec                 eax
            //   488bc2               | lea                 ecx, [0x21e70]

        $sequence_1 = { 4c89b8701c0000 4c89b8781c0000 4c89b8801c0000 4c89b8881c0000 4c89b8901c0000 4c89b8981c0000 4c89b8a01c0000 }
            // n = 7, score = 100
            //   4c89b8701c0000       | dec                 esp
            //   4c89b8781c0000       | mov                 dword ptr [eax + 0xd8], edi
            //   4c89b8801c0000       | dec                 esp
            //   4c89b8881c0000       | mov                 dword ptr [eax + 0xe0], edi
            //   4c89b8901c0000       | dec                 esp
            //   4c89b8981c0000       | mov                 dword ptr [eax + 0xe8], edi
            //   4c89b8a01c0000       | dec                 esp

        $sequence_2 = { 4c89b8c01a0000 4c89b8c81a0000 4c89b8d01a0000 4c89b8d81a0000 4c89b8e01a0000 4c89b8e81a0000 }
            // n = 6, score = 100
            //   4c89b8c01a0000       | call                dword ptr [eax + 0x20]
            //   4c89b8c81a0000       | dec                 esp
            //   4c89b8d01a0000       | mov                 edx, dword ptr [eax]
            //   4c89b8d81a0000       | inc                 ecx
            //   4c89b8e01a0000       | mov                 ecx, 6
            //   4c89b8e81a0000       | inc                 ecx

        $sequence_3 = { 0f84d6000000 4c8d155b7e0100 41b90a000000 4b8b04fa }
            // n = 4, score = 100
            //   0f84d6000000         | mov                 eax, ebp
            //   4c8d155b7e0100       | je                  0xea
            //   41b90a000000         | lea                 eax, [ecx - 1]
            //   4b8b04fa             | mov                 eax, dword ptr [edx + eax*4 + 0x1e088]

        $sequence_4 = { 4c89b8981d0000 4c89b8a01d0000 4c89b8a81d0000 4c89b8b01d0000 4c89b8b81d0000 4c89b8c01d0000 }
            // n = 6, score = 100
            //   4c89b8981d0000       | dec                 eax
            //   4c89b8a01d0000       | mov                 dword ptr [edx + 8], ecx
            //   4c89b8a81d0000       | dec                 eax
            //   4c89b8b01d0000       | lea                 ecx, [esp + 0x20]
            //   4c89b8b81d0000       | dec                 eax
            //   4c89b8c01d0000       | lea                 eax, [0x1448e]

        $sequence_5 = { 488b45d8 488908 488d0d6d720100 488b45d8 8990a8030000 488b45d8 48898888000000 }
            // n = 7, score = 100
            //   488b45d8             | dec                 esp
            //   488908               | mov                 dword ptr [eax + 0xd58], edi
            //   488d0d6d720100       | dec                 esp
            //   488b45d8             | mov                 dword ptr [eax + 0xd60], edi
            //   8990a8030000         | dec                 esp
            //   488b45d8             | mov                 dword ptr [eax + 0xe38], edi
            //   48898888000000       | dec                 esp

        $sequence_6 = { 4c89b850130000 4c89b858130000 4c89b860130000 4c89b868130000 }
            // n = 4, score = 100
            //   4c89b850130000       | dec                 eax
            //   4c89b858130000       | lea                 edx, [0x21b31]
            //   4c89b860130000       | dec                 eax
            //   4c89b868130000       | lea                 ecx, [ebp - 0x80]

        $sequence_7 = { 90 4c8d4001 41b901000000 488d1592df0100 488d4dd7 e8???????? }
            // n = 6, score = 100
            //   90                   | dec                 eax
            //   4c8d4001             | lea                 eax, [0xac25]
            //   41b901000000         | dec                 eax
            //   488d1592df0100       | mov                 dword ptr [ebp + 0xf], eax
            //   488d4dd7             | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 488d1559e10100 488bcf ff5018 48c7452f0f000000 48897527 }
            // n = 5, score = 100
            //   488d1559e10100       | dec                 esp
            //   488bcf               | mov                 dword ptr [eax + 0x12d8], edi
            //   ff5018               | dec                 esp
            //   48c7452f0f000000     | mov                 dword ptr [eax + 0x12e0], edi
            //   48897527             | dec                 esp

        $sequence_9 = { 4c89b818080000 4c89b820080000 4c89b828080000 4c89b830080000 4c89b838080000 4c89b840080000 }
            // n = 6, score = 100
            //   4c89b818080000       | dec                 esp
            //   4c89b820080000       | mov                 dword ptr [eax + 0x22e0], edi
            //   4c89b828080000       | dec                 esp
            //   4c89b830080000       | mov                 dword ptr [eax + 0x22e8], edi
            //   4c89b838080000       | dec                 esp
            //   4c89b840080000       | mov                 dword ptr [eax + 0x22f0], edi

    condition:
        7 of them and filesize < 372736
}