rule win_shadow_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shadow_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shadow_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b8580000000 483bc6 0f82f1060000 482bc6 49c7c0ffffffff }
            // n = 5, score = 100
            //   488b8580000000       | xor                 dh, dh
            //   483bc6               | inc                 esp
            //   0f82f1060000         | mov                 byte ptr [esp + 0x20], dh
            //   482bc6               | inc                 ebp
            //   49c7c0ffffffff       | xor                 ebp, ebp

        $sequence_1 = { 5f c3 488b542468 488d0db6590300 e8???????? 4c8b18 }
            // n = 6, score = 100
            //   5f                   | inc                 ecx
            //   c3                   | lea                 ecx, [ebp + 3]
            //   488b542468           | dec                 eax
            //   488d0db6590300       | lea                 edi, [0x23897]
            //   e8????????           |                     
            //   4c8b18               | jmp                 0x1370

        $sequence_2 = { e8???????? 448ba570010000 8b4c2438 488d15b7e5fcff 2b4c2448 41b826000000 894c2438 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   448ba570010000       | test                eax, eax
            //   8b4c2438             | jne                 0x149a
            //   488d15b7e5fcff       | dec                 eax
            //   2b4c2448             | lea                 ecx, [0x3f656]
            //   41b826000000         | test                eax, eax
            //   894c2438             | je                  0x14c3

        $sequence_3 = { 488b8c2430010000 4833cc e8???????? 4881c448010000 415e 415c 5e }
            // n = 7, score = 100
            //   488b8c2430010000     | mov                 edi, dword ptr [edi + eax*8]
            //   4833cc               | dec                 eax
            //   e8????????           |                     
            //   4881c448010000       | arpl                cx, dx
            //   415e                 | dec                 eax
            //   415c                 | lea                 eax, [0x2c81f]
            //   5e                   | dec                 ecx

        $sequence_4 = { 488d5570 4883bd880000000f 490f47d5 4533e4 4c89642420 4533c9 448b8580000000 }
            // n = 7, score = 100
            //   488d5570             | cmp                 dword ptr [ecx + 0x80], 0
            //   4883bd880000000f     | je                  0xfc7
            //   490f47d5             | dec                 eax
            //   4533e4               | mov                 ecx, dword ptr [ecx + 0x18]
            //   4c89642420           | dec                 eax
            //   4533c9               | lea                 eax, [ebx + 0x70]
            //   448b8580000000       | dec                 eax

        $sequence_5 = { 488bf1 48894c2428 488bea 7603 488b2a 4c8b6210 48899c2480010000 }
            // n = 7, score = 100
            //   488bf1               | mov                 dword ptr [ebp - 8], esi
            //   48894c2428           | inc                 esp
            //   488bea               | mov                 dword ptr [ebp], esi
            //   7603                 | dec                 esp
            //   488b2a               | mov                 dword ptr [ebp + 8], esi
            //   4c8b6210             | dec                 eax
            //   48899c2480010000     | mov                 dword ptr [esp + 0x50], eax

        $sequence_6 = { 488b5928 4885db 750d 488d5930 eb07 488d1d785b0400 33d2 }
            // n = 7, score = 100
            //   488b5928             | arpl                word ptr [eax + 4], cx
            //   4885db               | lea                 edx, [ecx - 0xb0]
            //   750d                 | mov                 dword ptr [ecx + edi - 4], edx
            //   488d5930             | dec                 eax
            //   eb07                 | mov                 dword ptr [esp + 0x58], ebx
            //   488d1d785b0400       | dec                 eax
            //   33d2                 | mov                 ecx, ebx

        $sequence_7 = { 664489bd1e010000 ebc2 418bff 488d15009d0100 488bcb e8???????? 4885c0 }
            // n = 7, score = 100
            //   664489bd1e010000     | mov                 dword ptr [esp + 0x20], esi
            //   ebc2                 | dec                 esp
            //   418bff               | mov                 edi, dword ptr [ebp - 0x80]
            //   488d15009d0100       | dec                 ebp
            //   488bcb               | mov                 eax, dword ptr [edi + 8]
            //   e8????????           |                     
            //   4885c0               | dec                 eax

        $sequence_8 = { e8???????? 90 0f57c0 0f11442458 660f6f0d???????? f30f7f4c2468 c644245800 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | mov                 eax, dword ptr [esi]
            //   0f57c0               | dec                 eax
            //   0f11442458           | arpl                word ptr [eax + 4], cx
            //   660f6f0d????????     |                     
            //   f30f7f4c2468         | mov                 edi, edx
            //   c644245800           | dec                 esp

        $sequence_9 = { 488bcf e8???????? 90 488d4c2450 e8???????? 488bc7 488b4d50 }
            // n = 7, score = 100
            //   488bcf               | mov                 dword ptr [ebx], ecx
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488d4c2450           | lea                 ecx, [eax + 8]
            //   e8????????           |                     
            //   488bc7               | movups              xmmword ptr [edx], xmm0
            //   488b4d50             | dec                 eax

    condition:
        7 of them and filesize < 727040
}