rule win_shapeshift_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shapeshift."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shapeshift"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 8985f4feffff 33db 6a05 ff15???????? 68???????? }
            // n = 6, score = 100
            //   57                   | push                edi
            //   8985f4feffff         | mov                 dword ptr [ebp - 0x10c], eax
            //   33db                 | xor                 ebx, ebx
            //   6a05                 | push                5
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_1 = { 8d0d009c4100 ba1d000000 e8???????? 5a c3 8d542408 }
            // n = 6, score = 100
            //   8d0d009c4100         | lea                 ecx, [0x419c00]
            //   ba1d000000           | mov                 edx, 0x1d
            //   e8????????           |                     
            //   5a                   | pop                 edx
            //   c3                   | ret                 
            //   8d542408             | lea                 edx, [esp + 8]

        $sequence_2 = { 51 ff15???????? 8bf0 89b5ecfdffff }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   89b5ecfdffff         | mov                 dword ptr [ebp - 0x214], esi

        $sequence_3 = { 6af6 ff15???????? 8b04bd38054200 834c0318ff 33c0 }
            // n = 5, score = 100
            //   6af6                 | push                -0xa
            //   ff15????????         |                     
            //   8b04bd38054200       | mov                 eax, dword ptr [edi*4 + 0x420538]
            //   834c0318ff           | or                  dword ptr [ebx + eax + 0x18], 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 8bf0 e8???????? 83c404 8bf8 33c9 66660f1f840000000000 0fbf044d3cfa4100 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bf8                 | mov                 edi, eax
            //   33c9                 | xor                 ecx, ecx
            //   66660f1f840000000000     | nop    word ptr [eax + eax]
            //   0fbf044d3cfa4100     | movsx               eax, word ptr [ecx*2 + 0x41fa3c]

        $sequence_5 = { f30f5e85ccfdffff f30f5905???????? e8???????? 83bde8fdffff00 741f 3bc7 }
            // n = 6, score = 100
            //   f30f5e85ccfdffff     | divss               xmm0, dword ptr [ebp - 0x234]
            //   f30f5905????????     |                     
            //   e8????????           |                     
            //   83bde8fdffff00       | cmp                 dword ptr [ebp - 0x218], 0
            //   741f                 | je                  0x21
            //   3bc7                 | cmp                 eax, edi

        $sequence_6 = { e8???????? 85f6 8bf0 6a0c 7550 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   85f6                 | test                esi, esi
            //   8bf0                 | mov                 esi, eax
            //   6a0c                 | push                0xc
            //   7550                 | jne                 0x52
            //   e8????????           |                     

        $sequence_7 = { 8995e8fdffff 57 898df8fdffff 899df0fdffff c785ecfdffff00000000 0f86ef010000 }
            // n = 6, score = 100
            //   8995e8fdffff         | mov                 dword ptr [ebp - 0x218], edx
            //   57                   | push                edi
            //   898df8fdffff         | mov                 dword ptr [ebp - 0x208], ecx
            //   899df0fdffff         | mov                 dword ptr [ebp - 0x210], ebx
            //   c785ecfdffff00000000     | mov    dword ptr [ebp - 0x214], 0
            //   0f86ef010000         | jbe                 0x1f5

    condition:
        7 of them and filesize < 303104
}