rule win_shimrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shimrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shimrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 ff750c 8b4d08 e8???????? 8b4508 5f }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   5f                   | pop                 edi

        $sequence_1 = { 6aff ff75fc 56 ff7514 ffd7 8bd8 8d4301 }
            // n = 7, score = 100
            //   6aff                 | push                -1
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   56                   | push                esi
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ffd7                 | call                edi
            //   8bd8                 | mov                 ebx, eax
            //   8d4301               | lea                 eax, [ebx + 1]

        $sequence_2 = { 8d4d50 e8???????? ff7570 e8???????? 8d4d50 }
            // n = 5, score = 100
            //   8d4d50               | lea                 ecx, [ebp + 0x50]
            //   e8????????           |                     
            //   ff7570               | push                dword ptr [ebp + 0x70]
            //   e8????????           |                     
            //   8d4d50               | lea                 ecx, [ebp + 0x50]

        $sequence_3 = { 85ff 7e1a 8b19 ff742410 8d0433 50 e8???????? }
            // n = 7, score = 100
            //   85ff                 | test                edi, edi
            //   7e1a                 | jle                 0x1c
            //   8b19                 | mov                 ebx, dword ptr [ecx]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   8d0433               | lea                 eax, [ebx + esi]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_4 = { ff15???????? 895df8 3bc3 0f8483000000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   3bc3                 | cmp                 eax, ebx
            //   0f8483000000         | je                  0x89

        $sequence_5 = { 53 8d45e8 56 50 e8???????? 6a02 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a02                 | push                2

        $sequence_6 = { 742e 837dfc04 7519 68???????? ff75f8 e8???????? 59 }
            // n = 7, score = 100
            //   742e                 | je                  0x30
            //   837dfc04             | cmp                 dword ptr [ebp - 4], 4
            //   7519                 | jne                 0x1b
            //   68????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_7 = { 8d4ddc e8???????? 85c0 754b 8d4df0 e8???????? }
            // n = 6, score = 100
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   754b                 | jne                 0x4d
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     

        $sequence_8 = { 33c0 40 c3 a810 7404 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   c3                   | ret                 
            //   a810                 | test                al, 0x10
            //   7404                 | je                  6

        $sequence_9 = { ff15???????? c20400 55 8bec 81ec88000000 8365ec00 53 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec88000000         | sub                 esp, 0x88
            //   8365ec00             | and                 dword ptr [ebp - 0x14], 0
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 65536
}