rule win_shipshape_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shipshape."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shipshape"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d9424f8010000 c1e902 f3a5 8bc8 }
            // n = 4, score = 100
            //   8d9424f8010000       | lea                 edx, [esp + 0x1f8]
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { 83f843 7c55 50 e8???????? }
            // n = 4, score = 100
            //   83f843               | cmp                 eax, 0x43
            //   7c55                 | jl                  0x57
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 8bf7 c1f805 83e61f 8d1c8560d54000 c1e603 }
            // n = 5, score = 100
            //   8bf7                 | mov                 esi, edi
            //   c1f805               | sar                 eax, 5
            //   83e61f               | and                 esi, 0x1f
            //   8d1c8560d54000       | lea                 ebx, [eax*4 + 0x40d560]
            //   c1e603               | shl                 esi, 3

        $sequence_3 = { 83e11f 8b3cbd60d54000 8d3ccf eb05 bf???????? }
            // n = 5, score = 100
            //   83e11f               | and                 ecx, 0x1f
            //   8b3cbd60d54000       | mov                 edi, dword ptr [edi*4 + 0x40d560]
            //   8d3ccf               | lea                 edi, [edi + ecx*8]
            //   eb05                 | jmp                 7
            //   bf????????           |                     

        $sequence_4 = { f3a5 8bcd 8d942434030000 83e103 f3a4 8dbc2434020000 83c9ff }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bcd                 | mov                 ecx, ebp
            //   8d942434030000       | lea                 edx, [esp + 0x334]
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8dbc2434020000       | lea                 edi, [esp + 0x234]
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_5 = { 808801c4400008 40 3dff000000 72f1 }
            // n = 4, score = 100
            //   808801c4400008       | or                  byte ptr [eax + 0x40c401], 8
            //   40                   | inc                 eax
            //   3dff000000           | cmp                 eax, 0xff
            //   72f1                 | jb                  0xfffffff3

        $sequence_6 = { 8bbc2410020000 83c9ff 33c0 8d54240c f2ae }
            // n = 5, score = 100
            //   8bbc2410020000       | mov                 edi, dword ptr [esp + 0x210]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_7 = { 55 ff15???????? 5d 5b 81c440060000 c3 56 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   81c440060000         | add                 esp, 0x640
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_8 = { 0f8430010000 8dbc2434010000 83c9ff 33c0 8d9424b4010000 }
            // n = 5, score = 100
            //   0f8430010000         | je                  0x136
            //   8dbc2434010000       | lea                 edi, [esp + 0x134]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   8d9424b4010000       | lea                 edx, [esp + 0x1b4]

        $sequence_9 = { 52 50 e8???????? 8b4c241c 8b542418 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]

    condition:
        7 of them and filesize < 338386
}