rule win_shortleash_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.shortleash."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shortleash"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff10 83c8ff f00fc1430c 83f801 750c 488b4c2450 488b01 }
            // n = 7, score = 100
            //   ff10                 | dec                 eax
            //   83c8ff               | test                eax, eax
            //   f00fc1430c           | je                  0x1e7c
            //   83f801               | dec                 eax
            //   750c                 | mov                 dword ptr [edi], eax
            //   488b4c2450           | dec                 ecx
            //   488b01               | mov                 ecx, dword ptr [esi]

        $sequence_1 = { e9???????? 4055 4883ec20 488bea ba90000000 488b4d30 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4055                 | dec                 eax
            //   4883ec20             | mov                 eax, dword ptr [ebp + 0x30]
            //   488bea               | dec                 ecx
            //   ba90000000           | lea                 edi, [ecx + eax*2]
            //   488b4d30             | dec                 edx
            //   e8????????           |                     

        $sequence_2 = { f30f7f4de8 4533f6 4c8975f8 418d4e10 e8???????? 488bd8 488d45d8 }
            // n = 7, score = 100
            //   f30f7f4de8           | dec                 eax
            //   4533f6               | mov                 dword ptr [ebx + 8], ecx
            //   4c8975f8             | dec                 eax
            //   418d4e10             | mov                 dword ptr [ebx], eax
            //   e8????????           |                     
            //   488bd8               | dec                 eax
            //   488d45d8             | mov                 ebx, dword ptr [esp + 0x30]

        $sequence_3 = { e9???????? 488d15d5580200 488bcf e8???????? 85c0 7504 488d7706 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d15d5580200       | jb                  0x10ac
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   85c0                 | sub                 eax, ecx
            //   7504                 | dec                 eax
            //   488d7706             | cmp                 eax, 0x30

        $sequence_4 = { e8???????? 488bd0 488d4c2440 e8???????? 90 488b8eb0000000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bd0               | dec                 eax
            //   488d4c2440           | mov                 esi, dword ptr [esp + 0x48]
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488b8eb0000000       | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_5 = { eb09 4c394810 7453 488b00 493b00 75f2 4d8b00 }
            // n = 7, score = 100
            //   eb09                 | mov                 esi, dword ptr [esp + 0x50]
            //   4c394810             | dec                 eax
            //   7453                 | lea                 eax, [0xfffdd22d]
            //   488b00               | dec                 eax
            //   493b00               | mov                 dword ptr [edi + 8], eax
            //   75f2                 | dec                 eax
            //   4d8b00               | lea                 eax, [0xfffdd166]

        $sequence_6 = { b910000000 e8???????? 488906 488d0d0e020000 488d1533090000 48895308 48890b }
            // n = 7, score = 100
            //   b910000000           | inc                 ecx
            //   e8????????           |                     
            //   488906               | pop                 ebp
            //   488d0d0e020000       | inc                 ecx
            //   488d1533090000       | pop                 esp
            //   48895308             | dec                 eax
            //   48890b               | mov                 ebx, dword ptr [esp + 0x50]

        $sequence_7 = { ff15???????? 488b542458 488bcb e8???????? 488b542450 488d4b08 e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488b542458           | ja                  0xfd9
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   488b542450           | lea                 edx, [0x83d7c]
            //   488d4b08             | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { e8???????? 8bf0 85c0 0f8548010000 488b4530 4c8d8348010000 482b8390000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 edx, edi
            //   85c0                 | dec                 eax
            //   0f8548010000         | mov                 ecx, esi
            //   488b4530             | dec                 eax
            //   4c8d8348010000       | mov                 edx, ebp
            //   482b8390000000       | test                al, al

        $sequence_9 = { ff15???????? 4839b3a8000000 7442 488bcb e8???????? 488b8ba8000000 e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4839b3a8000000       | nop                 
            //   7442                 | inc                 ecx
            //   488bcb               | mov                 eax, 0x1f1
            //   e8????????           |                     
            //   488b8ba8000000       | dec                 eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2415616
}