rule win_sidewinder_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sidewinder."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sidewinder"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945cc 837dcc00 0f8e37030000 0fbf4510 85c0 740e ff75c0 }
            // n = 7, score = 200
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   837dcc00             | cmp                 dword ptr [ebp - 0x34], 0
            //   0f8e37030000         | jle                 0x33d
            //   0fbf4510             | movsx               eax, word ptr [ebp + 0x10]
            //   85c0                 | test                eax, eax
            //   740e                 | je                  0x10
            //   ff75c0               | push                dword ptr [ebp - 0x40]

        $sequence_1 = { dfe0 9e 740e dd45cc dc1d???????? dfe0 9e }
            // n = 7, score = 200
            //   dfe0                 | fnstsw              ax
            //   9e                   | sahf                
            //   740e                 | je                  0x10
            //   dd45cc               | fld                 qword ptr [ebp - 0x34]
            //   dc1d????????         |                     
            //   dfe0                 | fnstsw              ax
            //   9e                   | sahf                

        $sequence_2 = { 8d45b8 50 8d45c8 50 8d45d8 50 8d45a8 }
            // n = 7, score = 200
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   50                   | push                eax
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8d45a8               | lea                 eax, [ebp - 0x58]

        $sequence_3 = { dbe2 8945dc 837ddc00 7d17 6a3c 68???????? ff75ec }
            // n = 7, score = 200
            //   dbe2                 | fnclex              
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   837ddc00             | cmp                 dword ptr [ebp - 0x24], 0
            //   7d17                 | jge                 0x19
            //   6a3c                 | push                0x3c
            //   68????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]

        $sequence_4 = { 817da0a3000000 750a 66830d????????ff eb54 837da058 740c 837da043 }
            // n = 7, score = 200
            //   817da0a3000000       | cmp                 dword ptr [ebp - 0x60], 0xa3
            //   750a                 | jne                 0xc
            //   66830d????????ff     |                     
            //   eb54                 | jmp                 0x56
            //   837da058             | cmp                 dword ptr [ebp - 0x60], 0x58
            //   740c                 | je                  0xe
            //   837da043             | cmp                 dword ptr [ebp - 0x60], 0x43

        $sequence_5 = { 8965f8 c745fc???????? 6a02 59 e8???????? 668945e0 8b4508 }
            // n = 7, score = 200
            //   8965f8               | mov                 dword ptr [ebp - 8], esp
            //   c745fc????????       |                     
            //   6a02                 | push                2
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   668945e0             | mov                 word ptr [ebp - 0x20], ax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_6 = { 50 6a00 e8???????? 8d45d4 50 6a00 e8???????? }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   e8????????           |                     
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_7 = { 83a59cfeffff00 8b45a0 89853cffffff 8d855cffffff 50 8b853cffffff 8b00 }
            // n = 7, score = 200
            //   83a59cfeffff00       | and                 dword ptr [ebp - 0x164], 0
            //   8b45a0               | mov                 eax, dword ptr [ebp - 0x60]
            //   89853cffffff         | mov                 dword ptr [ebp - 0xc4], eax
            //   8d855cffffff         | lea                 eax, [ebp - 0xa4]
            //   50                   | push                eax
            //   8b853cffffff         | mov                 eax, dword ptr [ebp - 0xc4]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_8 = { eb09 8d45ec 89856cffffff 8b856cffffff 8b00 8945b0 8d45d0 }
            // n = 7, score = 200
            //   eb09                 | jmp                 0xb
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   89856cffffff         | mov                 dword ptr [ebp - 0x94], eax
            //   8b856cffffff         | mov                 eax, dword ptr [ebp - 0x94]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   8d45d0               | lea                 eax, [ebp - 0x30]

        $sequence_9 = { e8???????? 898560ffffff eb07 83a560ffffff00 8b45c8 894588 c745b004000280 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   898560ffffff         | mov                 dword ptr [ebp - 0xa0], eax
            //   eb07                 | jmp                 9
            //   83a560ffffff00       | and                 dword ptr [ebp - 0xa0], 0
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   894588               | mov                 dword ptr [ebp - 0x78], eax
            //   c745b004000280       | mov                 dword ptr [ebp - 0x50], 0x80020004

    condition:
        7 of them and filesize < 679936
}