rule win_sienna_purple_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sienna_purple."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sienna_purple"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? c645fc05 e9???????? 83ff11 0f85b6000000 6a74 8d8560ffffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   e9????????           |                     
            //   83ff11               | cmp                 edi, 0x11
            //   0f85b6000000         | jne                 0xbc
            //   6a74                 | push                0x74
            //   8d8560ffffff         | lea                 eax, [ebp - 0xa0]

        $sequence_1 = { 8955f8 894514 3b45dc 0f8c41ffffff 5f 5e 5b }
            // n = 7, score = 100
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   894514               | mov                 dword ptr [ebp + 0x14], eax
            //   3b45dc               | cmp                 eax, dword ptr [ebp - 0x24]
            //   0f8c41ffffff         | jl                  0xffffff47
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_2 = { 8d86d4000000 50 8d86fc000000 50 8d45dc 50 e8???????? }
            // n = 7, score = 100
            //   8d86d4000000         | lea                 eax, [esi + 0xd4]
            //   50                   | push                eax
            //   8d86fc000000         | lea                 eax, [esi + 0xfc]
            //   50                   | push                eax
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 8d4ddc e9???????? 8d4dc8 e9???????? 8d8d28ffffff e9???????? 8d8d14ffffff }
            // n = 7, score = 100
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e9????????           |                     
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   e9????????           |                     
            //   8d8d28ffffff         | lea                 ecx, [ebp - 0xd8]
            //   e9????????           |                     
            //   8d8d14ffffff         | lea                 ecx, [ebp - 0xec]

        $sequence_4 = { 99 0bfe f7fb c1e708 0fb60c0a 8d4201 99 }
            // n = 7, score = 100
            //   99                   | cdq                 
            //   0bfe                 | or                  edi, esi
            //   f7fb                 | idiv                ebx
            //   c1e708               | shl                 edi, 8
            //   0fb60c0a             | movzx               ecx, byte ptr [edx + ecx]
            //   8d4201               | lea                 eax, [edx + 1]
            //   99                   | cdq                 

        $sequence_5 = { e8???????? 8bf0 83c410 85f6 0f858b050000 c785b8ebffffe05e4300 eb24 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c410               | add                 esp, 0x10
            //   85f6                 | test                esi, esi
            //   0f858b050000         | jne                 0x591
            //   c785b8ebffffe05e4300     | mov    dword ptr [ebp - 0x1448], 0x435ee0
            //   eb24                 | jmp                 0x26

        $sequence_6 = { 8d8d98fdffff f7d8 1bc0 05b1040000 50 e8???????? 8d45d4 }
            // n = 7, score = 100
            //   8d8d98fdffff         | lea                 ecx, [ebp - 0x268]
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   05b1040000           | add                 eax, 0x4b1
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d45d4               | lea                 eax, [ebp - 0x2c]

        $sequence_7 = { e8???????? 83c40c 85c0 0f85fa000000 50 8d45c8 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f85fa000000         | jne                 0x100
            //   50                   | push                eax
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   50                   | push                eax

        $sequence_8 = { e8???????? e9???????? 0f57c0 c745e800000000 8d4dd0 660fd645e0 f30f7f45d0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   0f57c0               | xorps               xmm0, xmm0
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   660fd645e0           | movq                qword ptr [ebp - 0x20], xmm0
            //   f30f7f45d0           | movdqu              xmmword ptr [ebp - 0x30], xmm0

        $sequence_9 = { e8???????? 8b8d74feffff 8d855cffffff 53 50 e8???????? 8d85dcfeffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b8d74feffff         | mov                 ecx, dword ptr [ebp - 0x18c]
            //   8d855cffffff         | lea                 eax, [ebp - 0xa4]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85dcfeffff         | lea                 eax, [ebp - 0x124]

    condition:
        7 of them and filesize < 2930688
}