rule win_siggen6_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.siggen6"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 741f 833d????????04 7416 833d????????05 740d 833d????????06 }
            // n = 6, score = 100
            //   741f                 | je                  0x21
            //   833d????????04       |                     
            //   7416                 | je                  0x18
            //   833d????????05       |                     
            //   740d                 | je                  0xf
            //   833d????????06       |                     

        $sequence_1 = { 53 ff15???????? 83c40c eb03 83c8ff 5f 5e }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   eb03                 | jmp                 5
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { 8b45f4 e8???????? ff758c 8bc6 ba03000000 e8???????? ff36 }
            // n = 7, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   ff758c               | push                dword ptr [ebp - 0x74]
            //   8bc6                 | mov                 eax, esi
            //   ba03000000           | mov                 edx, 3
            //   e8????????           |                     
            //   ff36                 | push                dword ptr [esi]

        $sequence_3 = { 8b55fc 8bc6 e8???????? eb21 b80a000000 e8???????? 8bd0 }
            // n = 7, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   eb21                 | jmp                 0x23
            //   b80a000000           | mov                 eax, 0xa
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_4 = { e8???????? 83c00b 50 8d95fcfdffff 8b45f0 8b08 ff511c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c00b               | add                 eax, 0xb
            //   50                   | push                eax
            //   8d95fcfdffff         | lea                 edx, [ebp - 0x204]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff511c               | call                dword ptr [ecx + 0x1c]

        $sequence_5 = { 8b06 e8???????? a3???????? ba???????? 8b06 e8???????? }
            // n = 6, score = 100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   e8????????           |                     
            //   a3????????           |                     
            //   ba????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   e8????????           |                     

        $sequence_6 = { 8b18 ff530c 8b9574feffff 8b45f8 8b0485c4d44600 8b08 ff5138 }
            // n = 7, score = 100
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff530c               | call                dword ptr [ebx + 0xc]
            //   8b9574feffff         | mov                 edx, dword ptr [ebp - 0x18c]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b0485c4d44600       | mov                 eax, dword ptr [eax*4 + 0x46d4c4]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5138               | call                dword ptr [ecx + 0x38]

        $sequence_7 = { a1???????? e8???????? 48 50 8d950cffffff 8b45e0 }
            // n = 6, score = 100
            //   a1????????           |                     
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   50                   | push                eax
            //   8d950cffffff         | lea                 edx, [ebp - 0xf4]
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]

        $sequence_8 = { 33d2 59 e8???????? 8b9574ffffff 8b45d8 8b08 ff512c }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   8b9574ffffff         | mov                 edx, dword ptr [ebp - 0x8c]
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff512c               | call                dword ptr [ecx + 0x2c]

        $sequence_9 = { 64ff32 648922 e8???????? e8???????? 8945f8 33d2 55 }
            // n = 7, score = 100
            //   64ff32               | push                dword ptr fs:[edx]
            //   648922               | mov                 dword ptr fs:[edx], esp
            //   e8????????           |                     
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   33d2                 | xor                 edx, edx
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 974848
}