rule win_silence_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.silence."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.silence"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? cc 8325????????00 c3 6a08 }
            // n = 5, score = 1800
            //   e8????????           |                     
            //   cc                   | int3                
            //   8325????????00       |                     
            //   c3                   | ret                 
            //   6a08                 | push                8

        $sequence_1 = { 8a4801 40 84c9 75f4 eb05 }
            // n = 5, score = 1800
            //   8a4801               | mov                 cl, byte ptr [eax + 1]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f4                 | jne                 0xfffffff6
            //   eb05                 | jmp                 7

        $sequence_2 = { 50 6a00 6a00 68???????? c745fc00000000 }
            // n = 5, score = 1800
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_3 = { 50 683f020f00 6a00 68???????? 6801000080 ff15???????? 68???????? }
            // n = 7, score = 1700
            //   50                   | push                eax
            //   683f020f00           | push                0xf023f
            //   6a00                 | push                0
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_4 = { 6801000080 ff15???????? 56 8d85f8feffff 50 }
            // n = 5, score = 1600
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   56                   | push                esi
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax

        $sequence_5 = { ff15???????? 6a00 6800000004 6a00 }
            // n = 4, score = 1600
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6800000004           | push                0x4000000
            //   6a00                 | push                0

        $sequence_6 = { 7502 f3c3 e9???????? e8???????? e9???????? 6a14 68???????? }
            // n = 7, score = 1600
            //   7502                 | jne                 4
            //   f3c3                 | ret                 
            //   e9????????           |                     
            //   e8????????           |                     
            //   e9????????           |                     
            //   6a14                 | push                0x14
            //   68????????           |                     

        $sequence_7 = { 68???????? ffd6 8b45fc 85c0 }
            // n = 4, score = 1600
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   85c0                 | test                eax, eax

        $sequence_8 = { 6800040000 ff30 c745fc00000000 57 ff15???????? }
            // n = 5, score = 1400
            //   6800040000           | push                0x400
            //   ff30                 | push                dword ptr [eax]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_9 = { 55 8bec 51 56 8b35???????? 6a00 6a00 }
            // n = 7, score = 1400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_10 = { 8b35???????? 6a00 6a00 6a00 6a00 8d45fc }
            // n = 6, score = 1400
            //   8b35????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_11 = { 84c9 75f4 eb0d 803800 7408 8a5a01 42 }
            // n = 7, score = 1400
            //   84c9                 | test                cl, cl
            //   75f4                 | jne                 0xfffffff6
            //   eb0d                 | jmp                 0xf
            //   803800               | cmp                 byte ptr [eax], 0
            //   7408                 | je                  0xa
            //   8a5a01               | mov                 bl, byte ptr [edx + 1]
            //   42                   | inc                 edx

        $sequence_12 = { 3acb 740a 8a4801 40 }
            // n = 4, score = 1400
            //   3acb                 | cmp                 cl, bl
            //   740a                 | je                  0xc
            //   8a4801               | mov                 cl, byte ptr [eax + 1]
            //   40                   | inc                 eax

        $sequence_13 = { 5b 5d c3 c60200 42 }
            // n = 5, score = 1400
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   c60200               | mov                 byte ptr [edx], 0
            //   42                   | inc                 edx

        $sequence_14 = { 8bf8 6a00 57 ff15???????? 8d45fc }
            // n = 5, score = 1400
            //   8bf8                 | mov                 edi, eax
            //   6a00                 | push                0
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_15 = { 50 56 ff15???????? 8b85b8f7ffff 85c0 75b6 ffb5acf7ffff }
            // n = 7, score = 1200
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b85b8f7ffff         | mov                 eax, dword ptr [ebp - 0x848]
            //   85c0                 | test                eax, eax
            //   75b6                 | jne                 0xffffffb8
            //   ffb5acf7ffff         | push                dword ptr [ebp - 0x854]

        $sequence_16 = { 8d85b8f7ffff 50 6800080000 8d85bcf7ffff 50 }
            // n = 5, score = 1200
            //   8d85b8f7ffff         | lea                 eax, [ebp - 0x848]
            //   50                   | push                eax
            //   6800080000           | push                0x800
            //   8d85bcf7ffff         | lea                 eax, [ebp - 0x844]
            //   50                   | push                eax

        $sequence_17 = { 6a00 8d8db4f7ffff 51 50 8d85bcf7ffff }
            // n = 5, score = 1200
            //   6a00                 | push                0
            //   8d8db4f7ffff         | lea                 ecx, [ebp - 0x84c]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8d85bcf7ffff         | lea                 eax, [ebp - 0x844]

        $sequence_18 = { e8???????? ff76f8 e8???????? 83c41c 895ef8 897ef0 5b }
            // n = 7, score = 1100
            //   e8????????           |                     
            //   ff76f8               | push                dword ptr [esi - 8]
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   895ef8               | mov                 dword ptr [esi - 8], ebx
            //   897ef0               | mov                 dword ptr [esi - 0x10], edi
            //   5b                   | pop                 ebx

        $sequence_19 = { 8b46f8 0346f4 57 ff7508 50 }
            // n = 5, score = 1100
            //   8b46f8               | mov                 eax, dword ptr [esi - 8]
            //   0346f4               | add                 eax, dword ptr [esi - 0xc]
            //   57                   | push                edi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_20 = { 8b01 52 8d95f0fdffff 52 }
            // n = 4, score = 1100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   52                   | push                edx
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]
            //   52                   | push                edx

        $sequence_21 = { e8???????? ff37 8b35???????? ffd6 }
            // n = 4, score = 1100
            //   e8????????           |                     
            //   ff37                 | push                dword ptr [edi]
            //   8b35????????         |                     
            //   ffd6                 | call                esi

        $sequence_22 = { 898df8fbffff 8d8dfcfbffff 51 ffb5f0fbffff }
            // n = 4, score = 1100
            //   898df8fbffff         | mov                 dword ptr [ebp - 0x408], ecx
            //   8d8dfcfbffff         | lea                 ecx, [ebp - 0x404]
            //   51                   | push                ecx
            //   ffb5f0fbffff         | push                dword ptr [ebp - 0x410]

        $sequence_23 = { ff5210 8b17 8bcf ff5208 }
            // n = 4, score = 1100
            //   ff5210               | call                dword ptr [edx + 0x10]
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   8bcf                 | mov                 ecx, edi
            //   ff5208               | call                dword ptr [edx + 8]

        $sequence_24 = { 52 ff10 8b95ecfdffff 03fa }
            // n = 4, score = 1100
            //   52                   | push                edx
            //   ff10                 | call                dword ptr [eax]
            //   8b95ecfdffff         | mov                 edx, dword ptr [ebp - 0x214]
            //   03fa                 | add                 edi, edx

        $sequence_25 = { e8???????? 8b4ef4 8bc7 2bc1 }
            // n = 4, score = 1100
            //   e8????????           |                     
            //   8b4ef4               | mov                 ecx, dword ptr [esi - 0xc]
            //   8bc7                 | mov                 eax, edi
            //   2bc1                 | sub                 eax, ecx

        $sequence_26 = { 99 83e203 03c2 c1f802 89442448 }
            // n = 5, score = 500
            //   99                   | mov                 edx, 0xc18
            //   83e203               | mov                 ecx, 0x40
            //   03c2                 | cdq                 
            //   c1f802               | and                 edx, 3
            //   89442448             | add                 eax, edx

        $sequence_27 = { ff15???????? ba180c0000 b940000000 ff15???????? }
            // n = 4, score = 500
            //   ff15????????         |                     
            //   ba180c0000           | dec                 eax
            //   b940000000           | lea                 ecx, [esp + 0x240]
            //   ff15????????         |                     

        $sequence_28 = { 8b05???????? d3e0 8b0d???????? 03c8 }
            // n = 4, score = 500
            //   8b05????????         |                     
            //   d3e0                 | movzx               ecx, al
            //   8b0d????????         |                     
            //   03c8                 | shl                 eax, cl

        $sequence_29 = { d3e0 0fb6c8 8b05???????? d3e0 }
            // n = 4, score = 500
            //   d3e0                 | sar                 eax, 2
            //   0fb6c8               | mov                 dword ptr [esp + 0x40], eax
            //   8b05????????         |                     
            //   d3e0                 | shl                 eax, cl

        $sequence_30 = { e8???????? ba00040000 b940000000 ff15???????? }
            // n = 4, score = 500
            //   e8????????           |                     
            //   ba00040000           | shl                 eax, cl
            //   b940000000           | add                 ecx, eax
            //   ff15????????         |                     

        $sequence_31 = { ff15???????? 41b804010000 488d542430 488d4c2430 ff15???????? 85c0 }
            // n = 6, score = 500
            //   ff15????????         |                     
            //   41b804010000         | shl                 eax, cl
            //   488d542430           | test                eax, eax
            //   488d4c2430           | inc                 ecx
            //   ff15????????         |                     
            //   85c0                 | mov                 eax, 0x104

        $sequence_32 = { d3f8 0fb60d???????? d3e0 85c0 }
            // n = 4, score = 500
            //   d3f8                 | mov                 edx, 0x400
            //   0fb60d????????       |                     
            //   d3e0                 | mov                 ecx, 0x40
            //   85c0                 | sar                 eax, cl

        $sequence_33 = { ff15???????? 488d542430 488d8c2440020000 ff15???????? }
            // n = 4, score = 500
            //   ff15????????         |                     
            //   488d542430           | dec                 eax
            //   488d8c2440020000     | lea                 edx, [esp + 0x30]
            //   ff15????????         |                     

        $sequence_34 = { 8d0441 33d2 b905000000 f7f1 }
            // n = 4, score = 400
            //   8d0441               | lea                 eax, [ecx + eax*2]
            //   33d2                 | xor                 edx, edx
            //   b905000000           | mov                 ecx, 5
            //   f7f1                 | div                 ecx

        $sequence_35 = { 750e 68???????? ff15???????? c20800 53 8b1d???????? }
            // n = 6, score = 400
            //   750e                 | jne                 0x10
            //   68????????           |                     
            //   ff15????????         |                     
            //   c20800               | ret                 8
            //   53                   | push                ebx
            //   8b1d????????         |                     

        $sequence_36 = { 8bec ff4d08 755d 833d????????04 }
            // n = 4, score = 400
            //   8bec                 | mov                 ebp, esp
            //   ff4d08               | dec                 dword ptr [ebp + 8]
            //   755d                 | jne                 0x5f
            //   833d????????04       |                     

        $sequence_37 = { c705????????00000000 c705????????04000000 ff15???????? 85c0 750b }
            // n = 5, score = 400
            //   c705????????00000000     |     
            //   c705????????04000000     |     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750b                 | jne                 0xd

        $sequence_38 = { 7507 68???????? ffd7 6a00 6a00 6a01 }
            // n = 6, score = 400
            //   7507                 | jne                 9
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_39 = { 53 8b1d???????? 57 0f57c0 }
            // n = 4, score = 400
            //   53                   | push                ebx
            //   8b1d????????         |                     
            //   57                   | push                edi
            //   0f57c0               | xorps               xmm0, xmm0

        $sequence_40 = { 68???????? ff15???????? a3???????? 85c0 750e 68???????? ff15???????? }
            // n = 7, score = 400
            //   68????????           |                     
            //   ff15????????         |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   750e                 | jne                 0x10
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_41 = { ff15???????? 68c0d40100 ff15???????? e9???????? }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   68c0d40100           | push                0x1d4c0
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_42 = { ffd3 5e 85c0 7507 68???????? ffd7 5f }
            // n = 7, score = 400
            //   ffd3                 | call                ebx
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   5f                   | pop                 edi

        $sequence_43 = { c705????????00000000 c705????????00000000 ffd3 8b3d???????? }
            // n = 4, score = 400
            //   c705????????00000000     |     
            //   c705????????00000000     |     
            //   ffd3                 | call                ebx
            //   8b3d????????         |                     

        $sequence_44 = { 0305???????? 0b45f0 3305???????? a3???????? }
            // n = 4, score = 100
            //   0305????????         |                     
            //   0b45f0               | or                  eax, dword ptr [ebp - 0x10]
            //   3305????????         |                     
            //   a3????????           |                     

        $sequence_45 = { 03048db0354200 eb05 b8???????? f6402820 }
            // n = 4, score = 100
            //   03048db0354200       | add                 eax, dword ptr [ecx*4 + 0x4235b0]
            //   eb05                 | jmp                 7
            //   b8????????           |                     
            //   f6402820             | test                byte ptr [eax + 0x28], 0x20

        $sequence_46 = { 03048db0354200 eb02 8bc6 80782900 }
            // n = 4, score = 100
            //   03048db0354200       | add                 eax, dword ptr [ecx*4 + 0x4235b0]
            //   eb02                 | jmp                 4
            //   8bc6                 | mov                 eax, esi
            //   80782900             | cmp                 byte ptr [eax + 0x29], 0

        $sequence_47 = { 03048db0354200 50 ff15???????? 5d }
            // n = 4, score = 100
            //   03048db0354200       | add                 eax, dword ptr [ecx*4 + 0x4235b0]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 70128640
}