rule win_silentgh0st_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.silentgh0st."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.silentgh0st"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c9 c3 8b45fc ff7018 ff750c e8???????? 59 }
            // n = 7, score = 100
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ff7018               | push                dword ptr [eax + 0x18]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_1 = { 33c4 89842488000000 8b8424a0000000 8b8c2494000000 53 8b9c24a0000000 55 }
            // n = 7, score = 100
            //   33c4                 | xor                 eax, esp
            //   89842488000000       | mov                 dword ptr [esp + 0x88], eax
            //   8b8424a0000000       | mov                 eax, dword ptr [esp + 0xa0]
            //   8b8c2494000000       | mov                 ecx, dword ptr [esp + 0x94]
            //   53                   | push                ebx
            //   8b9c24a0000000       | mov                 ebx, dword ptr [esp + 0xa0]
            //   55                   | push                ebp

        $sequence_2 = { e8???????? 8bcf 85c0 7507 e8???????? ebb0 6834020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bcf                 | mov                 ecx, edi
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   e8????????           |                     
            //   ebb0                 | jmp                 0xffffffb2
            //   6834020000           | push                0x234

        $sequence_3 = { 33c9 83e701 894c2418 897c2414 a900000004 0f8596000000 c744241801030000 }
            // n = 7, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   83e701               | and                 edi, 1
            //   894c2418             | mov                 dword ptr [esp + 0x18], ecx
            //   897c2414             | mov                 dword ptr [esp + 0x14], edi
            //   a900000004           | test                eax, 0x4000000
            //   0f8596000000         | jne                 0x9c
            //   c744241801030000     | mov                 dword ptr [esp + 0x18], 0x301

        $sequence_4 = { 8bc6 c1f805 8bfe 53 8d1c8500c40e10 8b03 83e71f }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8bfe                 | mov                 edi, esi
            //   53                   | push                ebx
            //   8d1c8500c40e10       | lea                 ebx, [eax*4 + 0x100ec400]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   83e71f               | and                 edi, 0x1f

        $sequence_5 = { 8d04454c950e10 8bc8 2bce 6a03 d1f9 68???????? 2bd9 }
            // n = 7, score = 100
            //   8d04454c950e10       | lea                 eax, [eax*2 + 0x100e954c]
            //   8bc8                 | mov                 ecx, eax
            //   2bce                 | sub                 ecx, esi
            //   6a03                 | push                3
            //   d1f9                 | sar                 ecx, 1
            //   68????????           |                     
            //   2bd9                 | sub                 ebx, ecx

        $sequence_6 = { 83c420 e9???????? 8b96bc000000 8b8290000000 3bc5 7514 6a0a }
            // n = 7, score = 100
            //   83c420               | add                 esp, 0x20
            //   e9????????           |                     
            //   8b96bc000000         | mov                 edx, dword ptr [esi + 0xbc]
            //   8b8290000000         | mov                 eax, dword ptr [edx + 0x90]
            //   3bc5                 | cmp                 eax, ebp
            //   7514                 | jne                 0x16
            //   6a0a                 | push                0xa

        $sequence_7 = { 8d85f8feffff 6a5c 50 e8???????? 59 59 3bc3 }
            // n = 7, score = 100
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   6a5c                 | push                0x5c
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   3bc3                 | cmp                 eax, ebx

        $sequence_8 = { 8b4a10 03c0 80e108 03c0 0fb6d1 83c404 03c0 }
            // n = 7, score = 100
            //   8b4a10               | mov                 ecx, dword ptr [edx + 0x10]
            //   03c0                 | add                 eax, eax
            //   80e108               | and                 cl, 8
            //   03c0                 | add                 eax, eax
            //   0fb6d1               | movzx               edx, cl
            //   83c404               | add                 esp, 4
            //   03c0                 | add                 eax, eax

        $sequence_9 = { 8d8304010000 8bd6 2bd0 b910000000 89542420 eb04 8b542420 }
            // n = 7, score = 100
            //   8d8304010000         | lea                 eax, [ebx + 0x104]
            //   8bd6                 | mov                 edx, esi
            //   2bd0                 | sub                 edx, eax
            //   b910000000           | mov                 ecx, 0x10
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   eb04                 | jmp                 6
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]

    condition:
        7 of them and filesize < 2065408
}