rule win_simda_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.simda."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.simda"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8955ec 897de0 3bce 0f8278feffff 5b }
            // n = 5, score = 700
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   897de0               | mov                 dword ptr [ebp - 0x20], edi
            //   3bce                 | cmp                 ecx, esi
            //   0f8278feffff         | jb                  0xfffffe7e
            //   5b                   | pop                 ebx

        $sequence_1 = { 83c424 33c0 668945d0 8845fe }
            // n = 4, score = 700
            //   83c424               | add                 esp, 0x24
            //   33c0                 | xor                 eax, eax
            //   668945d0             | mov                 word ptr [ebp - 0x30], ax
            //   8845fe               | mov                 byte ptr [ebp - 2], al

        $sequence_2 = { 8b85e8feffff 85c0 7505 8d41ff eb0f 83f801 }
            // n = 6, score = 700
            //   8b85e8feffff         | mov                 eax, dword ptr [ebp - 0x118]
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   8d41ff               | lea                 eax, [ecx - 1]
            //   eb0f                 | jmp                 0x11
            //   83f801               | cmp                 eax, 1

        $sequence_3 = { 33f6 68ff000000 8d85f1feffff 56 50 }
            // n = 5, score = 700
            //   33f6                 | xor                 esi, esi
            //   68ff000000           | push                0xff
            //   8d85f1feffff         | lea                 eax, [ebp - 0x10f]
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_4 = { 83ec24 53 56 57 50 6800040000 }
            // n = 6, score = 700
            //   83ec24               | sub                 esp, 0x24
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   50                   | push                eax
            //   6800040000           | push                0x400

        $sequence_5 = { 83c408 8945f0 85c0 7508 6a01 }
            // n = 5, score = 700
            //   83c408               | add                 esp, 8
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa
            //   6a01                 | push                1

        $sequence_6 = { 8bf8 0faf7dfc c1e210 0b55f8 3bfa }
            // n = 5, score = 700
            //   8bf8                 | mov                 edi, eax
            //   0faf7dfc             | imul                edi, dword ptr [ebp - 4]
            //   c1e210               | shl                 edx, 0x10
            //   0b55f8               | or                  edx, dword ptr [ebp - 8]
            //   3bfa                 | cmp                 edi, edx

        $sequence_7 = { b910000000 be???????? 8d7db4 f3a5 66a5 }
            // n = 5, score = 700
            //   b910000000           | mov                 ecx, 0x10
            //   be????????           |                     
            //   8d7db4               | lea                 edi, [ebp - 0x4c]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]

        $sequence_8 = { 8bd1 c1ea10 8955ec 8bf8 }
            // n = 4, score = 700
            //   8bd1                 | mov                 edx, ecx
            //   c1ea10               | shr                 edx, 0x10
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { 85c0 75dd 8b4d0c 8bc3 2bc2 }
            // n = 5, score = 700
            //   85c0                 | test                eax, eax
            //   75dd                 | jne                 0xffffffdf
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8bc3                 | mov                 eax, ebx
            //   2bc2                 | sub                 eax, edx

    condition:
        7 of them and filesize < 1581056
}