rule win_simplefilemover_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.simplefilemover."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.simplefilemover"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bfc f3a5 e8???????? 81c420020000 }
            // n = 4, score = 500
            //   8bfc                 | mov                 edi, esp
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   e8????????           |                     
            //   81c420020000         | add                 esp, 0x220

        $sequence_1 = { 7d07 33c0 e9???????? 6820020000 ff15???????? }
            // n = 5, score = 400
            //   7d07                 | jge                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   6820020000           | push                0x220
            //   ff15????????         |                     

        $sequence_2 = { e8???????? 81c420020000 85c0 7407 68???????? eb05 68???????? }
            // n = 7, score = 300
            //   e8????????           |                     
            //   81c420020000         | add                 esp, 0x220
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   68????????           |                     
            //   eb05                 | jmp                 7
            //   68????????           |                     

        $sequence_3 = { b988000000 8bf3 8bfc f3a5 }
            // n = 4, score = 300
            //   b988000000           | mov                 ecx, 0x88
            //   8bf3                 | mov                 esi, ebx
            //   8bfc                 | mov                 edi, esp
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_4 = { 57 668b01 33f6 33db 33ff }
            // n = 5, score = 200
            //   57                   | push                edi
            //   668b01               | mov                 ax, word ptr [ecx]
            //   33f6                 | xor                 esi, esi
            //   33db                 | xor                 ebx, ebx
            //   33ff                 | xor                 edi, edi

        $sequence_5 = { 750f c78508daffff00000000 e9???????? 6a04 8d8d54daffff }
            // n = 5, score = 200
            //   750f                 | jne                 0x11
            //   c78508daffff00000000     | mov    dword ptr [ebp - 0x25f8], 0
            //   e9????????           |                     
            //   6a04                 | push                4
            //   8d8d54daffff         | lea                 ecx, [ebp - 0x25ac]

        $sequence_6 = { 3bc3 0f8ec7020000 0145ec 397dec 7416 8b45ec }
            // n = 6, score = 200
            //   3bc3                 | cmp                 eax, ebx
            //   0f8ec7020000         | jle                 0x2cd
            //   0145ec               | add                 dword ptr [ebp - 0x14], eax
            //   397dec               | cmp                 dword ptr [ebp - 0x14], edi
            //   7416                 | je                  0x18
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_7 = { 7433 8bcb 663d5c00 7503 }
            // n = 4, score = 200
            //   7433                 | je                  0x35
            //   8bcb                 | mov                 ecx, ebx
            //   663d5c00             | cmp                 ax, 0x5c
            //   7503                 | jne                 5

        $sequence_8 = { 56 8b74241c 57 8a8800010000 8a9001010000 33ff 884c2408 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]
            //   57                   | push                edi
            //   8a8800010000         | mov                 cl, byte ptr [eax + 0x100]
            //   8a9001010000         | mov                 dl, byte ptr [eax + 0x101]
            //   33ff                 | xor                 edi, edi
            //   884c2408             | mov                 byte ptr [esp + 8], cl

        $sequence_9 = { 8b742424 53 81e1ff000000 55 81e6ff000000 }
            // n = 5, score = 200
            //   8b742424             | mov                 esi, dword ptr [esp + 0x24]
            //   53                   | push                ebx
            //   81e1ff000000         | and                 ecx, 0xff
            //   55                   | push                ebp
            //   81e6ff000000         | and                 esi, 0xff

        $sequence_10 = { 3bfb 0f8c54ffffff 8a4c242c 5d 5b 5f }
            // n = 6, score = 200
            //   3bfb                 | cmp                 edi, ebx
            //   0f8c54ffffff         | jl                  0xffffff5a
            //   8a4c242c             | mov                 cl, byte ptr [esp + 0x2c]
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi

        $sequence_11 = { 895df4 eb03 8b7df0 8d4601 be00010000 99 }
            // n = 6, score = 200
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   eb03                 | jmp                 5
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   8d4601               | lea                 eax, [esi + 1]
            //   be00010000           | mov                 esi, 0x100
            //   99                   | cdq                 

        $sequence_12 = { 8b7c2418 8b5c2428 47 897c2418 0fbfff 3bfb 0f8c54ffffff }
            // n = 7, score = 200
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   8b5c2428             | mov                 ebx, dword ptr [esp + 0x28]
            //   47                   | inc                 edi
            //   897c2418             | mov                 dword ptr [esp + 0x18], edi
            //   0fbfff               | movsx               edi, di
            //   3bfb                 | cmp                 edi, ebx
            //   0f8c54ffffff         | jl                  0xffffff5a

        $sequence_13 = { 8b7c2424 b940000000 f3a5 83c40c }
            // n = 4, score = 200
            //   8b7c2424             | mov                 edi, dword ptr [esp + 0x24]
            //   b940000000           | mov                 ecx, 0x40
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   83c40c               | add                 esp, 0xc

        $sequence_14 = { e8???????? 83c410 e9???????? 83bd24daffff00 7e0c c78508daffff00000000 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   e9????????           |                     
            //   83bd24daffff00       | cmp                 dword ptr [ebp - 0x25dc], 0
            //   7e0c                 | jle                 0xe
            //   c78508daffff00000000     | mov    dword ptr [ebp - 0x25f8], 0

        $sequence_15 = { 83c102 42 6685c0 75ea 85f6 7417 8b4c2414 }
            // n = 7, score = 200
            //   83c102               | add                 ecx, 2
            //   42                   | inc                 edx
            //   6685c0               | test                ax, ax
            //   75ea                 | jne                 0xffffffec
            //   85f6                 | test                esi, esi
            //   7417                 | je                  0x19
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]

        $sequence_16 = { 0f8eda000000 8b4c2408 8b742424 53 }
            // n = 4, score = 200
            //   0f8eda000000         | jle                 0xe0
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8b742424             | mov                 esi, dword ptr [esp + 0x24]
            //   53                   | push                ebx

        $sequence_17 = { ebca ebc8 ebc6 ebc4 ebc2 }
            // n = 5, score = 200
            //   ebca                 | jmp                 0xffffffcc
            //   ebc8                 | jmp                 0xffffffca
            //   ebc6                 | jmp                 0xffffffc8
            //   ebc4                 | jmp                 0xffffffc6
            //   ebc2                 | jmp                 0xffffffc4

        $sequence_18 = { 50 8d85b0ddffff 50 e8???????? 8b45f4 03c0 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8d85b0ddffff         | lea                 eax, [ebp - 0x2250]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   03c0                 | add                 eax, eax

        $sequence_19 = { 6a00 6a00 6a04 6a00 6a02 6800000040 8d85f8fdffff }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   6800000040           | push                0x40000000
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]

        $sequence_20 = { 50 ff15???????? 898510daffff 6a00 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   898510daffff         | mov                 dword ptr [ebp - 0x25f0], eax
            //   6a00                 | push                0

        $sequence_21 = { 51 8b9554faffff 52 ff15???????? 898508daffff 83bd08daffffff }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   8b9554faffff         | mov                 edx, dword ptr [ebp - 0x5ac]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   898508daffff         | mov                 dword ptr [ebp - 0x25f8], eax
            //   83bd08daffffff       | cmp                 dword ptr [ebp - 0x25f8], -1

    condition:
        7 of them and filesize < 57344
}