rule win_sinowal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sinowal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sinowal"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 0f85b3000000 837df800 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85b3000000         | jne                 0xb9
            //   837df800             | cmp                 dword ptr [ebp - 8], 0

        $sequence_1 = { c7854cfdffff28000000 83bd4cfdffff03 7305 e9???????? 8b8d4cfdffff }
            // n = 5, score = 200
            //   c7854cfdffff28000000     | mov    dword ptr [ebp - 0x2b4], 0x28
            //   83bd4cfdffff03       | cmp                 dword ptr [ebp - 0x2b4], 3
            //   7305                 | jae                 7
            //   e9????????           |                     
            //   8b8d4cfdffff         | mov                 ecx, dword ptr [ebp - 0x2b4]

        $sequence_2 = { 8b45fc 83c001 8945fc 8b4d0c d1e9 394dfc }
            // n = 6, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c001               | add                 eax, 1
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   d1e9                 | shr                 ecx, 1
            //   394dfc               | cmp                 dword ptr [ebp - 4], ecx

        $sequence_3 = { 33d2 7596 837de800 7417 8b4508 8b08 }
            // n = 6, score = 200
            //   33d2                 | xor                 edx, edx
            //   7596                 | jne                 0xffffff98
            //   837de800             | cmp                 dword ptr [ebp - 0x18], 0
            //   7417                 | je                  0x19
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_4 = { 8995ecfeffff c785c4feffff00000000 c745fc00000000 c745f800000000 c685f0feffff00 68ff000000 6a00 }
            // n = 7, score = 200
            //   8995ecfeffff         | mov                 dword ptr [ebp - 0x114], edx
            //   c785c4feffff00000000     | mov    dword ptr [ebp - 0x13c], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c685f0feffff00       | mov                 byte ptr [ebp - 0x110], 0
            //   68ff000000           | push                0xff
            //   6a00                 | push                0

        $sequence_5 = { 50 e8???????? 83c40c c745fc01000000 c745f804010000 8d4df8 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   c745f804010000       | mov                 dword ptr [ebp - 8], 0x104
            //   8d4df8               | lea                 ecx, [ebp - 8]

        $sequence_6 = { 51 ff15???????? 33c0 eb03 83c8ff }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   eb03                 | jmp                 5
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_7 = { 52 ff15???????? c745f400000000 eb09 8b45f4 }
            // n = 5, score = 200
            //   52                   | push                edx
            //   ff15????????         |                     
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   eb09                 | jmp                 0xb
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_8 = { 7405 e9???????? 6830020000 6a00 }
            // n = 4, score = 200
            //   7405                 | je                  7
            //   e9????????           |                     
            //   6830020000           | push                0x230
            //   6a00                 | push                0

        $sequence_9 = { 8b4dfc 0fb611 33d0 8b45fc 8810 8b4dfc }
            // n = 6, score = 200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   0fb611               | movzx               edx, byte ptr [ecx]
            //   33d0                 | xor                 edx, eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8810                 | mov                 byte ptr [eax], dl
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 73728
}