rule win_skinnyboy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.skinnyboy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skinnyboy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7403 50 ffd7 ffd3 6a00 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   ffd3                 | call                ebx
            //   6a00                 | push                0

        $sequence_1 = { 0fb68098b20010 83e00f eb02 33c0 8bbdc4fdffff 6bc009 0fb6bc38b8b20010 }
            // n = 7, score = 100
            //   0fb68098b20010       | movzx               eax, byte ptr [eax + 0x1000b298]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8bbdc4fdffff         | mov                 edi, dword ptr [ebp - 0x23c]
            //   6bc009               | imul                eax, eax, 9
            //   0fb6bc38b8b20010     | movzx               edi, byte ptr [eax + edi + 0x1000b2b8]

        $sequence_2 = { 668b444de4 6631444dd0 41 3bca 72f1 33c0 }
            // n = 6, score = 100
            //   668b444de4           | mov                 ax, word ptr [ebp + ecx*2 - 0x1c]
            //   6631444dd0           | xor                 word ptr [ebp + ecx*2 - 0x30], ax
            //   41                   | inc                 ecx
            //   3bca                 | cmp                 ecx, edx
            //   72f1                 | jb                  0xfffffff3
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 8d8278040110 8945e4 803800 8bc8 7435 8a4101 84c0 }
            // n = 7, score = 100
            //   8d8278040110         | lea                 eax, [edx + 0x10010478]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   803800               | cmp                 byte ptr [eax], 0
            //   8bc8                 | mov                 ecx, eax
            //   7435                 | je                  0x37
            //   8a4101               | mov                 al, byte ptr [ecx + 1]
            //   84c0                 | test                al, al

        $sequence_4 = { 833cfdd80b011000 7515 68a00f0000 56 ff15???????? }
            // n = 5, score = 100
            //   833cfdd80b011000     | cmp                 dword ptr [edi*8 + 0x10010bd8], 0
            //   7515                 | jne                 0x17
            //   68a00f0000           | push                0xfa0
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_5 = { 50 ffd6 8b85e0feffff 85c0 7403 50 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b85e0feffff         | mov                 eax, dword ptr [ebp - 0x120]
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   50                   | push                eax

        $sequence_6 = { ffb55cfbffff ff15???????? 85c0 0f85d2feffff ffb55cfbffff ff15???????? ff33 }
            // n = 7, score = 100
            //   ffb55cfbffff         | push                dword ptr [ebp - 0x4a4]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85d2feffff         | jne                 0xfffffed8
            //   ffb55cfbffff         | push                dword ptr [ebp - 0x4a4]
            //   ff15????????         |                     
            //   ff33                 | push                dword ptr [ebx]

        $sequence_7 = { ff15???????? 8bf0 6a01 56 ff15???????? 8d4c2420 51 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   6a01                 | push                1
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   51                   | push                ecx

        $sequence_8 = { 7413 8a8c1564feffff 308c15e4feffff 42 3bd0 72ed }
            // n = 6, score = 100
            //   7413                 | je                  0x15
            //   8a8c1564feffff       | mov                 cl, byte ptr [ebp + edx - 0x19c]
            //   308c15e4feffff       | xor                 byte ptr [ebp + edx - 0x11c], cl
            //   42                   | inc                 edx
            //   3bd0                 | cmp                 edx, eax
            //   72ed                 | jb                  0xffffffef

        $sequence_9 = { ff15???????? 8d442430 50 ff15???????? 85c0 742d }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   742d                 | je                  0x2f

    condition:
        7 of them and filesize < 176128
}