rule win_skip20_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.skip20."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skip20"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb74114 8b540824 4803d3 8b7c0820 4885d2 0f840b1d0000 }
            // n = 6, score = 200
            //   0fb74114             | arpl                word ptr [eax], cx
            //   8b540824             | dec                 eax
            //   4803d3               | mov                 dword ptr [esi + 8], ecx
            //   8b7c0820             | add                 dword ptr [ecx + 0x18], -2
            //   4885d2               | js                  0x1d66
            //   0f840b1d0000         | dec                 eax

        $sequence_1 = { 488d0c40 4c8d0584fe0100 4d8b04c8 488bd7 }
            // n = 4, score = 200
            //   488d0c40             | mov                 eax, 0x10
            //   4c8d0584fe0100       | dec                 eax
            //   4d8b04c8             | movsx               ecx, byte ptr [eax]
            //   488bd7               | dec                 eax

        $sequence_2 = { 894c2430 89542428 488d15fd2c0100 e9???????? 4c896c2450 66c744245cff25 }
            // n = 6, score = 200
            //   894c2430             | dec                 eax
            //   89542428             | mov                 edi, ecx
            //   488d15fd2c0100       | dec                 eax
            //   e9????????           |                     
            //   4c896c2450           | sub                 esp, 0x20
            //   66c744245cff25       | dec                 eax

        $sequence_3 = { 488d0db5220100 e8???????? eb4a 4c896c2450 440fb74c2472 440fb7442470 }
            // n = 6, score = 200
            //   488d0db5220100       | sub                 ecx, 4
            //   e8????????           |                     
            //   eb4a                 | cmp                 ecx, -4
            //   4c896c2450           | jne                 0xe17
            //   440fb74c2472         | inc                 esp
            //   440fb7442470         | mov                 ebx, dword ptr [ebx]

        $sequence_4 = { 4c8d254c540100 488b0d???????? bf01000000 897c2460 }
            // n = 4, score = 200
            //   4c8d254c540100       | dec                 eax
            //   488b0d????????       |                     
            //   bf01000000           | mov                 dword ptr [esp + 0x4240], ebp
            //   897c2460             | dec                 eax

        $sequence_5 = { 8bd6 81e200004000 747e 41ff4c2418 781e }
            // n = 5, score = 200
            //   8bd6                 | mov                 dword ptr [ecx + 0x10], eax
            //   81e200004000         | dec                 eax
            //   747e                 | mov                 dword ptr [ecx + 0x18], eax
            //   41ff4c2418           | dec                 eax
            //   781e                 | inc                 edx

        $sequence_6 = { ffc9 7432 ffc9 0f85150a0000 814e0400000002 4180e304 }
            // n = 6, score = 200
            //   ffc9                 | jne                 0x1af3
            //   7432                 | dec                 esp
            //   ffc9                 | mov                 dword ptr [esp + 0x60], esp
            //   0f85150a0000         | dec                 esp
            //   814e0400000002       | mov                 dword ptr [esp + 0x20], esi
            //   4180e304             | xor                 ebx, ebx

        $sequence_7 = { e8???????? 0fb64732 ffc3 3bd8 72dd 4c21aea0000000 0fb74f18 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   0fb64732             | je                  0x2df
            //   ffc3                 | cmp                 edx, 3
            //   3bd8                 | je                  0x2df
            //   72dd                 | cmp                 edx, 6
            //   4c21aea0000000       | dec                 eax
            //   0fb74f18             | mov                 dword ptr [esi + 8], ecx

        $sequence_8 = { 7418 0fbae119 730a f68424b800000008 7508 41be01000000 }
            // n = 6, score = 200
            //   7418                 | jmp                 0x1eeb
            //   0fbae119             | or                  dword ptr [esi + 4], 0x2000000
            //   730a                 | inc                 ecx
            //   f68424b800000008     | test                bl, 1
            //   7508                 | je                  0x1f11
            //   41be01000000         | or                  dword ptr [esi + 4], 0x2000000

        $sequence_9 = { 0fb744247c 89442438 0fb74c247a 894c2430 0fb7542478 89542428 488d15652f0100 }
            // n = 7, score = 200
            //   0fb744247c           | inc                 ecx
            //   89442438             | lea                 eax, [esi - 0x14]
            //   0fb74c247a           | dec                 eax
            //   894c2430             | mov                 ebp, ecx
            //   0fb7542478           | dec                 esp
            //   89542428             | lea                 ebp, [0xffff9fd8]
            //   488d15652f0100       | dec                 ebp

    condition:
        7 of them and filesize < 794624
}