rule win_skynet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.skynet."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.skynet"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8ba42438010000 4c8b4c2460 48b8ffffffffffffff7f 4c898c2430010000 4889bc2440010000 4939c4 }
            // n = 6, score = 100
            //   4c8ba42438010000     | dec                 eax
            //   4c8b4c2460           | lea                 ecx, [0x8dbe66]
            //   48b8ffffffffffffff7f     | mov    edx, dword ptr [eax]
            //   4c898c2430010000     | dec                 esp
            //   4889bc2440010000     | add                 eax, eax
            //   4939c4               | dec                 ecx

        $sequence_1 = { 4889d9 e8???????? 4889f1 e8???????? 488d8c24b0000000 e8???????? 4c89f1 }
            // n = 7, score = 100
            //   4889d9               | mov                 edx, eax
            //   e8????????           |                     
            //   4889f1               | dec                 eax
            //   e8????????           |                     
            //   488d8c24b0000000     | mov                 eax, dword ptr [ebx]
            //   e8????????           |                     
            //   4c89f1               | dec                 eax

        $sequence_2 = { 0fb654243f 4889c8 4883e0fc 4809d0 48894520 e8???????? 488d8c24b0000000 }
            // n = 7, score = 100
            //   0fb654243f           | xor                 edx, edx
            //   4889c8               | mov                 dword ptr [ecx + 8], eax
            //   4883e0fc             | dec                 eax
            //   4809d0               | lea                 eax, [0x8bd074]
            //   48894520             | dec                 eax
            //   e8????????           |                     
            //   488d8c24b0000000     | mov                 dword ptr [ecx], eax

        $sequence_3 = { 488d059c478b00 31d2 4889f1 48894310 4883c028 48898380000000 e8???????? }
            // n = 7, score = 100
            //   488d059c478b00       | lea                 eax, [0x99d439]
            //   31d2                 | dec                 eax
            //   4889f1               | mov                 ecx, eax
            //   48894310             | call                eax
            //   4883c028             | dec                 eax
            //   48898380000000       | mov                 dword ptr [ebp - 8], 0
            //   e8????????           |                     

        $sequence_4 = { 4889cb 488d0d21fd8900 e8???????? 4889c2 488b03 488b4008 488b04d0 }
            // n = 7, score = 100
            //   4889cb               | dec                 esp
            //   488d0d21fd8900       | cmp                 ecx, esp
            //   e8????????           |                     
            //   4889c2               | je                  0xadb
            //   488b03               | dec                 eax
            //   488b4008             | mov                 eax, dword ptr [esp + 0x1c0]
            //   488b04d0             | dec                 eax

        $sequence_5 = { 4c894c2428 488d5001 e8???????? 4c8b4c2428 488b442420 4c894c2430 }
            // n = 6, score = 100
            //   4c894c2428           | lea                 eax, [0x8b906c]
            //   488d5001             | dec                 eax
            //   e8????????           |                     
            //   4c8b4c2428           | mov                 dword ptr [ebx], eax
            //   488b442420           | dec                 eax
            //   4c894c2430           | add                 eax, 0x28

        $sequence_6 = { 488b01 4889cb 480358e8 488d0586478a00 488903 488b05???????? 488d4b18 }
            // n = 7, score = 100
            //   488b01               | dec                 eax
            //   4889cb               | mov                 edx, ebp
            //   480358e8             | dec                 eax
            //   488d0586478a00       | mov                 eax, dword ptr [esp + 0x70]
            //   488903               | dec                 eax
            //   488b05????????       |                     
            //   488d4b18             | mov                 ecx, dword ptr [ebx]

        $sequence_7 = { 48c783b801000000000000 488983a8010000 0fb787e0000000 488d7b10 4889f9 668983b0010000 488d053dde8d00 }
            // n = 7, score = 100
            //   48c783b801000000000000     | lea    edx, [eax + 1]
            //   488983a8010000       | dec                 eax
            //   0fb787e0000000       | mov                 ebp, dword ptr [esp + 0xa8]
            //   488d7b10             | dec                 eax
            //   4889f9               | mov                 eax, 0xffffffff
            //   668983b0010000       | dec                 eax
            //   488d053dde8d00       | lea                 ebx, [esp + 0x40]

        $sequence_8 = { c705????????01000000 4883c010 488905???????? e8???????? 488d35d1c58b00 488b15???????? 664d0f6ec5 }
            // n = 7, score = 100
            //   c705????????01000000     |     
            //   4883c010             | mov                 dword ptr [eax], 6
            //   488905????????       |                     
            //   e8????????           |                     
            //   488d35d1c58b00       | dec                 eax
            //   488b15????????       |                     
            //   664d0f6ec5           | mov                 dword ptr [eax + 8], edx

        $sequence_9 = { e8???????? 488b4c2460 4c39e9 740f 488b442470 488d540002 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b4c2460           | mov                 ecx, dword ptr [esp + 0x50]
            //   4c39e9               | dec                 eax
            //   740f                 | mov                 edx, ebp
            //   488b442470           | dec                 esp
            //   488d540002           | mov                 ecx, esp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 20419584
}