rule win_slickshoes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.slickshoes."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slickshoes"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff3424 5b 81c404000000 31ca 59 e9???????? 5e }
            // n = 7, score = 100
            //   ff3424               | push                dword ptr [esp]
            //   5b                   | pop                 ebx
            //   81c404000000         | add                 esp, 4
            //   31ca                 | xor                 edx, ecx
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   5e                   | pop                 esi

        $sequence_1 = { ff742404 5b 8f0424 e9???????? 871424 8b2424 e9???????? }
            // n = 7, score = 100
            //   ff742404             | push                dword ptr [esp + 4]
            //   5b                   | pop                 ebx
            //   8f0424               | pop                 dword ptr [esp]
            //   e9????????           |                     
            //   871424               | xchg                dword ptr [esp], edx
            //   8b2424               | mov                 esp, dword ptr [esp]
            //   e9????????           |                     

        $sequence_2 = { e9???????? 890424 e9???????? 8b1c24 81c404000000 01d6 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   890424               | mov                 dword ptr [esp], eax
            //   e9????????           |                     
            //   8b1c24               | mov                 ebx, dword ptr [esp]
            //   81c404000000         | add                 esp, 4
            //   01d6                 | add                 esi, edx
            //   e9????????           |                     

        $sequence_3 = { e9???????? 5c 81c5aae2bb7f 8b1424 56 e9???????? 58 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   5c                   | pop                 esp
            //   81c5aae2bb7f         | add                 ebp, 0x7fbbe2aa
            //   8b1424               | mov                 edx, dword ptr [esp]
            //   56                   | push                esi
            //   e9????????           |                     
            //   58                   | pop                 eax

        $sequence_4 = { fc 5d e5b4 d070d3 ac 4d f3b694 }
            // n = 7, score = 100
            //   fc                   | cld                 
            //   5d                   | pop                 ebp
            //   e5b4                 | in                  eax, 0xb4
            //   d070d3               | sal                 byte ptr [eax - 0x2d], 1
            //   ac                   | lodsb               al, byte ptr [esi]
            //   4d                   | dec                 ebp
            //   f3b694               | mov                 dh, 0x94

        $sequence_5 = { 8a12 be00020000 81c61f000000 0017 81ee40000000 89ef b90a000000 }
            // n = 7, score = 100
            //   8a12                 | mov                 dl, byte ptr [edx]
            //   be00020000           | mov                 esi, 0x200
            //   81c61f000000         | add                 esi, 0x1f
            //   0017                 | add                 byte ptr [edi], dl
            //   81ee40000000         | sub                 esi, 0x40
            //   89ef                 | mov                 edi, ebp
            //   b90a000000           | mov                 ecx, 0xa

        $sequence_6 = { ff3424 ff3424 e9???????? 55 bda9d61ffa 29e8 5d }
            // n = 7, score = 100
            //   ff3424               | push                dword ptr [esp]
            //   ff3424               | push                dword ptr [esp]
            //   e9????????           |                     
            //   55                   | push                ebp
            //   bda9d61ffa           | mov                 ebp, 0xfa1fd6a9
            //   29e8                 | sub                 eax, ebp
            //   5d                   | pop                 ebp

        $sequence_7 = { ff3424 5b 51 890424 89e0 83ec04 893c24 }
            // n = 7, score = 100
            //   ff3424               | push                dword ptr [esp]
            //   5b                   | pop                 ebx
            //   51                   | push                ecx
            //   890424               | mov                 dword ptr [esp], eax
            //   89e0                 | mov                 eax, esp
            //   83ec04               | sub                 esp, 4
            //   893c24               | mov                 dword ptr [esp], edi

        $sequence_8 = { e9???????? 52 ba3c0d7e47 e9???????? 59 83ec04 891424 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   52                   | push                edx
            //   ba3c0d7e47           | mov                 edx, 0x477e0d3c
            //   e9????????           |                     
            //   59                   | pop                 ecx
            //   83ec04               | sub                 esp, 4
            //   891424               | mov                 dword ptr [esp], edx

        $sequence_9 = { e9???????? 5d 83c104 870c24 8b2424 e9???????? 81ec04000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   5d                   | pop                 ebp
            //   83c104               | add                 ecx, 4
            //   870c24               | xchg                dword ptr [esp], ecx
            //   8b2424               | mov                 esp, dword ptr [esp]
            //   e9????????           |                     
            //   81ec04000000         | sub                 esp, 4

    condition:
        7 of them and filesize < 11198464
}