rule win_slimagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.slimagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slimagent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bc2 488d0df5440200 0f57c0 48890b 488d5308 488d4808 0f1102 }
            // n = 7, score = 100
            //   488bc2               | dec                 eax
            //   488d0df5440200       | mov                 edx, dword ptr [ebp - 0x38]
            //   0f57c0               | dec                 esp
            //   48890b               | lea                 eax, [0x1fb4e]
            //   488d5308             | test                eax, eax
            //   488d4808             | je                  0x441
            //   0f1102               | dec                 ecx

        $sequence_1 = { b801000000 874110 85c0 7427 8364244000 488d05d2a5feff 4889442448 }
            // n = 7, score = 100
            //   b801000000           | dec                 eax
            //   874110               | lea                 ecx, [ebp - 0x20]
            //   85c0                 | nop                 
            //   7427                 | dec                 eax
            //   8364244000           | mov                 eax, dword ptr [ebx]
            //   488d05d2a5feff       | dec                 eax
            //   4889442448           | arpl                word ptr [eax], cx

        $sequence_2 = { c3 4053 4883ec20 488d054bcf0200 488bd9 488901 f6c201 }
            // n = 7, score = 100
            //   c3                   | mov                 edx, 0x56da4870
            //   4053                 | xchg                eax, esi
            //   4883ec20             | int1                
            //   488d054bcf0200       | test                dword ptr [ecx + 0x17], edi
            //   488bd9               | test                eax, eax
            //   488901               | je                  0xa3
            //   f6c201               | mov                 ecx, 2

        $sequence_3 = { 0f1102 e8???????? 488d058c780200 488903 488bc3 4883c420 5b }
            // n = 7, score = 100
            //   0f1102               | lea                 ecx, [0xd2e5]
            //   e8????????           |                     
            //   488d058c780200       | vmulsd              xmm0, xmm2, xmm2
            //   488903               | vfmadd213sd         xmm0, xmm3, xmm2
            //   488bc3               | cmp                 ecx, 0xfffffc02
            //   4883c420             | dec                 eax
            //   5b                   | lea                 edx, [0x12c34]

        $sequence_4 = { 66413b444b02 7515 4883c102 4883f90b 7415 0fb7044a 66413b044b }
            // n = 7, score = 100
            //   66413b444b02         | lea                 ecx, [edx + 0x48]
            //   7515                 | dec                 eax
            //   4883c102             | lea                 ecx, [edx + 0x80]
            //   4883f90b             | dec                 eax
            //   7415                 | lea                 ecx, [edx + 0x48]
            //   0fb7044a             | pop                 ebp
            //   66413b044b           | ret                 

        $sequence_5 = { 488d0c4f 41b810000000 488d15004c0400 e8???????? 6646892c77 eb7d 48c744242008000000 }
            // n = 7, score = 100
            //   488d0c4f             | dec                 ecx
            //   41b810000000         | mov                 edx, dword ptr [edi + edx*8 + 0x44fa0]
            //   488d15004c0400       | test                eax, eax
            //   e8????????           |                     
            //   6646892c77           | je                  0xaa4
            //   eb7d                 | jns                 0xa82
            //   48c744242008000000     | dec    eax

        $sequence_6 = { 4c8b83f0000000 498bc0 482bc1 483bd0 772f 488d3411 }
            // n = 6, score = 100
            //   4c8b83f0000000       | dec                 eax
            //   498bc0               | test                eax, eax
            //   482bc1               | jne                 0xcfa
            //   483bd0               | dec                 eax
            //   772f                 | lea                 eax, [0x1d6ec]
            //   488d3411             | dec                 eax

        $sequence_7 = { 488bc2 48c1e83f 4803d0 4863c2 4869c880aefeff 488d0535240100 89531c }
            // n = 7, score = 100
            //   488bc2               | mov                 eax, dword ptr [ebp - 0x20]
            //   48c1e83f             | dec                 eax
            //   4803d0               | mov                 edx, dword ptr [ebp - 0x31]
            //   4863c2               | dec                 ecx
            //   4869c880aefeff       | sub                 edx, esi
            //   488d0535240100       | dec                 ecx
            //   89531c               | mov                 eax, esi

        $sequence_8 = { 4803fa 4d8bc6 33d2 488bcf e8???????? 42c6043700 eb0f }
            // n = 7, score = 100
            //   4803fa               | xor                 al, al
            //   4d8bc6               | dec                 eax
            //   33d2                 | mov                 ecx, dword ptr [ebp + 0x50]
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   42c6043700           | lea                 edx, [0x14a56]
            //   eb0f                 | xor                 ebx, ebx

        $sequence_9 = { 48899fc8000000 668919 488d8fd8000000 4883bff000000008 7207 }
            // n = 5, score = 100
            //   48899fc8000000       | inc                 esp
            //   668919               | mov                 ecx, eax
            //   488d8fd8000000       | mov                 ebx, eax
            //   4883bff000000008     | dec                 esp
            //   7207                 | mov                 eax, dword ptr [edi + 8]

    condition:
        7 of them and filesize < 769024
}