rule win_slip_screen_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.slip_screen."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slip_screen"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb0c 4881c7e8000000 4885f6 7405 488bce ff17 4d85f6 }
            // n = 7, score = 100
            //   eb0c                 | inc                 ebp
            //   4881c7e8000000       | cmovns              eax, esi
            //   4885f6               | jmp                 0xbd8
            //   7405                 | test                eax, eax
            //   488bce               | jne                 0xbcc
            //   ff17                 | test                ecx, ecx
            //   4d85f6               | inc                 ecx

        $sequence_1 = { 4885c9 0f8498000000 4863413c 4533db 448b8c0888000000 }
            // n = 5, score = 100
            //   4885c9               | mov                 ecx, ebx
            //   0f8498000000         | dec                 eax
            //   4863413c             | mov                 dword ptr [edi + 0x20], eax
            //   4533db               | mov                 edx, esi
            //   448b8c0888000000     | dec                 eax

        $sequence_2 = { 48898798000000 4885c0 0f8462020000 41b8ce48ccfd 8bd6 488bcb }
            // n = 6, score = 100
            //   48898798000000       | mov                 eax, ebx
            //   4885c0               | dec                 eax
            //   0f8462020000         | imul                edx, ecx
            //   41b8ce48ccfd         | dec                 ebp
            //   8bd6                 | mov                 eax, ebx
            //   488bcb               | dec                 cx

        $sequence_3 = { 7447 410fb702 6685c0 7438 8d4abf 6683f919 448d4220 }
            // n = 7, score = 100
            //   7447                 | dec                 esp
            //   410fb702             | mov                 dword ptr [esp + 0x20], ebp
            //   6685c0               | mov                 dword ptr [ebp + 0x148], 0x104
            //   7438                 | xor                 edx, edx
            //   8d4abf               | dec                 esp
            //   6683f919             | mov                 eax, ecx
            //   448d4220             | inc                 esp

        $sequence_4 = { eb02 33c0 4c8d9c2490040000 498b5b28 498b6b30 }
            // n = 5, score = 100
            //   eb02                 | dec                 ecx
            //   33c0                 | mov                 esi, dword ptr [eax]
            //   4c8d9c2490040000     | dec                 eax
            //   498b5b28             | mov                 dword ptr [esp + 8], ebx
            //   498b6b30             | dec                 eax

        $sequence_5 = { 4903c1 4d8bc8 488bc8 48c1e020 48c1e920 480bc8 0fb7c1 }
            // n = 7, score = 100
            //   4903c1               | mov                 ecx, edx
            //   4d8bc8               | dec                 esp
            //   488bc8               | lea                 eax, [0x7db5]
            //   48c1e020             | and                 ecx, 0x3f
            //   48c1e920             | dec                 eax
            //   480bc8               | mov                 eax, edx
            //   0fb7c1               | dec                 eax

        $sequence_6 = { 0f1000 0f1145c4 f20f104810 f20f114dd4 8b4018 8945dc }
            // n = 6, score = 100
            //   0f1000               | xor                 ecx, ecx
            //   0f1145c4             | mov                 dword ptr [esp + 0x28], ebx
            //   f20f104810           | dec                 eax
            //   f20f114dd4           | mov                 eax, dword ptr [edi + 8]
            //   8b4018               | dec                 eax
            //   8945dc               | lea                 edx, [esp + 0x70]

        $sequence_7 = { 488b8100010000 4885c0 7403 f0ff00 488d4138 41b806000000 488d1547960000 }
            // n = 7, score = 100
            //   488b8100010000       | mov                 dword ptr [edi + ebx*8], eax
            //   4885c0               | dec                 esp
            //   7403                 | lea                 edi, [0xfffeddb3]
            //   f0ff00               | mov                 esi, 0xe3
            //   488d4138             | lea                 eax, [esi + ebx]
            //   41b806000000         | inc                 ecx
            //   488d1547960000       | mov                 eax, 0x55

        $sequence_8 = { 488bd0 48c1e020 48c1ea20 480bd0 0fb7c2 6633443bfa }
            // n = 6, score = 100
            //   488bd0               | neg                 eax
            //   48c1e020             | lea                 ebp, [edx - 1]
            //   48c1ea20             | add                 ebp, dword ptr [edi + 0x50]
            //   480bd0               | mov                 edx, dword ptr [edi + 0x54]
            //   0fb7c2               | dec                 esi
            //   6633443bfa           | lea                 eax, [ecx + esi]

        $sequence_9 = { 0fafca 4403c9 440fafc8 458bc1 440fafc0 428d0c0a }
            // n = 6, score = 100
            //   0fafca               | mov                 dword ptr [edi + 0x80], eax
            //   4403c9               | dec                 eax
            //   440fafc8             | test                eax, eax
            //   458bc1               | je                  0x10be
            //   440fafc0             | dec                 eax
            //   428d0c0a             | mov                 ecx, ebx

    condition:
        7 of them and filesize < 282624
}