rule win_slub_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.slub."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slub"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8520fbffff 50 68???????? 8d8d08fbffff e8???????? 8bc8 e8???????? }
            // n = 7, score = 100
            //   8d8520fbffff         | lea                 eax, [ebp - 0x4e0]
            //   50                   | push                eax
            //   68????????           |                     
            //   8d8d08fbffff         | lea                 ecx, [ebp - 0x4f8]
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     

        $sequence_1 = { 0f848d000000 833801 56 8b74240c 0f8581000000 80bf3803000000 53 }
            // n = 7, score = 100
            //   0f848d000000         | je                  0x93
            //   833801               | cmp                 dword ptr [eax], 1
            //   56                   | push                esi
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   0f8581000000         | jne                 0x87
            //   80bf3803000000       | cmp                 byte ptr [edi + 0x338], 0
            //   53                   | push                ebx

        $sequence_2 = { 55 33f6 c644242400 53 89742420 e8???????? }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   33f6                 | xor                 esi, esi
            //   c644242400           | mov                 byte ptr [esp + 0x24], 0
            //   53                   | push                ebx
            //   89742420             | mov                 dword ptr [esp + 0x20], esi
            //   e8????????           |                     

        $sequence_3 = { 837f2c00 8b6c2428 89473c 897740 7527 3b6b10 0f84d90f0000 }
            // n = 7, score = 100
            //   837f2c00             | cmp                 dword ptr [edi + 0x2c], 0
            //   8b6c2428             | mov                 ebp, dword ptr [esp + 0x28]
            //   89473c               | mov                 dword ptr [edi + 0x3c], eax
            //   897740               | mov                 dword ptr [edi + 0x40], esi
            //   7527                 | jne                 0x29
            //   3b6b10               | cmp                 ebp, dword ptr [ebx + 0x10]
            //   0f84d90f0000         | je                  0xfdf

        $sequence_4 = { 85db 741a 33f6 85ed 7e14 56 }
            // n = 6, score = 100
            //   85db                 | test                ebx, ebx
            //   741a                 | je                  0x1c
            //   33f6                 | xor                 esi, esi
            //   85ed                 | test                ebp, ebp
            //   7e14                 | jle                 0x16
            //   56                   | push                esi

        $sequence_5 = { c645fc16 8d8d80fdffff 8b85d4fdffff 83c018 50 e8???????? c645fc17 }
            // n = 7, score = 100
            //   c645fc16             | mov                 byte ptr [ebp - 4], 0x16
            //   8d8d80fdffff         | lea                 ecx, [ebp - 0x280]
            //   8b85d4fdffff         | mov                 eax, dword ptr [ebp - 0x22c]
            //   83c018               | add                 eax, 0x18
            //   50                   | push                eax
            //   e8????????           |                     
            //   c645fc17             | mov                 byte ptr [ebp - 4], 0x17

        $sequence_6 = { 0f842c060000 85c0 8b44241c 0f95c1 888815040000 8b4008 85c0 }
            // n = 7, score = 100
            //   0f842c060000         | je                  0x632
            //   85c0                 | test                eax, eax
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   0f95c1               | setne               cl
            //   888815040000         | mov                 byte ptr [eax + 0x415], cl
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   85c0                 | test                eax, eax

        $sequence_7 = { 83c418 85ff 7425 57 e8???????? 50 57 }
            // n = 7, score = 100
            //   83c418               | add                 esp, 0x18
            //   85ff                 | test                edi, edi
            //   7425                 | je                  0x27
            //   57                   | push                edi
            //   e8????????           |                     
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_8 = { 8bf8 83c408 85ff 75cf 38442411 0f84700a0000 6a01 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   83c408               | add                 esp, 8
            //   85ff                 | test                edi, edi
            //   75cf                 | jne                 0xffffffd1
            //   38442411             | cmp                 byte ptr [esp + 0x11], al
            //   0f84700a0000         | je                  0xa76
            //   6a01                 | push                1

        $sequence_9 = { 8d8358020000 50 8d8664040000 50 e8???????? 83c408 84c0 }
            // n = 7, score = 100
            //   8d8358020000         | lea                 eax, [ebx + 0x258]
            //   50                   | push                eax
            //   8d8664040000         | lea                 eax, [esi + 0x464]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   84c0                 | test                al, al

    condition:
        7 of them and filesize < 1785856
}